"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _type_registry = require("./application/type_registry");
var _get_add_connector_flyout = require("./common/get_add_connector_flyout");
var _get_edit_connector_flyout = require("./common/get_edit_connector_flyout");
var _get_add_rule_flyout = require("./common/get_add_rule_flyout");
var _get_edit_rule_flyout = require("./common/get_edit_rule_flyout");
var _get_alerts_table = require("./common/get_alerts_table");
var _get_field_browser = require("./common/get_field_browser");
var _get_rule_status_dropdown = require("./common/get_rule_status_dropdown");
var _get_rule_tag_filter = require("./common/get_rule_tag_filter");
var _get_rule_status_filter = require("./common/get_rule_status_filter");
var _get_rule_tag_badge = require("./common/get_rule_tag_badge");
var _get_rule_event_log_list = require("./common/get_rule_event_log_list");
var _get_rules_list_notify_badge = require("./common/get_rules_list_notify_badge");
var _get_rules_list = require("./common/get_rules_list");
var _get_action_form = require("./common/get_action_form");
var _get_rule_status_panel = require("./common/get_rule_status_panel");
var _experimental_features_service = require("./common/experimental_features_service");
var _experimental_features = require("../common/experimental_features");
var _register_alerts_table_configuration = require("./application/sections/alerts_table/alerts_page/register_alerts_table_configuration");
var _constants = require("./common/constants");
var _get_alerts_table_state = require("./common/get_alerts_table_state");
var _get_alerts_search_bar = require("./common/get_alerts_search_bar");
var _get_rule_definition = require("./common/get_rule_definition");
var _get_rule_alerts_summary = require("./common/get_rule_alerts_summary");
var _get_rule_snooze_modal = require("./common/get_rule_snooze_modal");
var _get_rules_settings_link = require("./common/get_rules_settings_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class Plugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "actionTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "ruleTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "alertsTableConfigurationRegistry", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "connectorServices", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.actionTypeRegistry = new _type_registry.TypeRegistry();
    this.ruleTypeRegistry = new _type_registry.TypeRegistry();
    this.alertsTableConfigurationRegistry = new _type_registry.TypeRegistry();
    this.config = ctx.config.get();
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || []);
  }
  setup(core, plugins) {
    const actionTypeRegistry = this.actionTypeRegistry;
    const ruleTypeRegistry = this.ruleTypeRegistry;
    const alertsTableConfigurationRegistry = this.alertsTableConfigurationRegistry;
    this.connectorServices = {
      validateEmailAddresses: plugins.actions.validateEmailAddresses
    };
    _experimental_features_service.ExperimentalFeaturesService.init({
      experimentalFeatures: this.experimentalFeatures
    });
    const featureTitle = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.displayName', {
      defaultMessage: 'Rules'
    });
    const featureDescription = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.displayDescription', {
      defaultMessage: 'Detect conditions using rules.'
    });
    const connectorsFeatureTitle = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.connectors.displayName', {
      defaultMessage: 'Connectors'
    });
    const connectorsFeatureDescription = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.connectors.displayDescription', {
      defaultMessage: 'Connect third-party software with your alerting data.'
    });
    if (plugins.home) {
      plugins.home.featureCatalogue.register({
        id: _constants.PLUGIN_ID,
        title: featureTitle,
        description: featureDescription,
        icon: 'watchesApp',
        path: _ruleDataUtils.triggersActionsRoute,
        showOnHomePage: false,
        category: 'admin'
      });
      plugins.home.featureCatalogue.register({
        id: _constants.CONNECTORS_PLUGIN_ID,
        title: connectorsFeatureTitle,
        description: connectorsFeatureDescription,
        icon: 'watchesApp',
        path: _ruleDataUtils.triggersActionsRoute,
        showOnHomePage: false,
        category: 'admin'
      });
    }
    plugins.management.sections.section.insightsAndAlerting.registerApp({
      id: _constants.PLUGIN_ID,
      title: featureTitle,
      order: 0,
      async mount(params) {
        var _plugins$cloud;
        const [coreStart, pluginsStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/app')));

        // The `/api/features` endpoint requires the "Global All" Kibana privilege. Users with a
        // subset of this privilege are not authorized to access this endpoint and will receive a 404
        // error that causes the Alerting view to fail to load.
        let kibanaFeatures;
        try {
          kibanaFeatures = await pluginsStart.features.getFeatures();
        } catch (err) {
          kibanaFeatures = [];
        }
        return renderApp({
          ...coreStart,
          actions: plugins.actions,
          data: pluginsStart.data,
          dataViews: pluginsStart.dataViews,
          dataViewEditor: pluginsStart.dataViewEditor,
          charts: pluginsStart.charts,
          alerting: pluginsStart.alerting,
          spaces: pluginsStart.spaces,
          unifiedSearch: pluginsStart.unifiedSearch,
          isCloud: Boolean((_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.isCloudEnabled),
          element: params.element,
          theme$: params.theme$,
          storage: new _public.Storage(window.localStorage),
          setBreadcrumbs: params.setBreadcrumbs,
          history: params.history,
          actionTypeRegistry,
          ruleTypeRegistry,
          alertsTableConfigurationRegistry,
          kibanaFeatures
        });
      }
    });
    plugins.management.sections.section.insightsAndAlerting.registerApp({
      id: _constants.CONNECTORS_PLUGIN_ID,
      title: connectorsFeatureTitle,
      order: 2,
      async mount(params) {
        var _plugins$cloud2;
        const [coreStart, pluginsStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/connectors_app')));

        // The `/api/features` endpoint requires the "Global All" Kibana privilege. Users with a
        // subset of this privilege are not authorized to access this endpoint and will receive a 404
        // error that causes the Alerting view to fail to load.
        let kibanaFeatures;
        try {
          kibanaFeatures = await pluginsStart.features.getFeatures();
        } catch (err) {
          kibanaFeatures = [];
        }
        return renderApp({
          ...coreStart,
          actions: plugins.actions,
          data: pluginsStart.data,
          dataViews: pluginsStart.dataViews,
          dataViewEditor: pluginsStart.dataViewEditor,
          charts: pluginsStart.charts,
          alerting: pluginsStart.alerting,
          spaces: pluginsStart.spaces,
          unifiedSearch: pluginsStart.unifiedSearch,
          isCloud: Boolean((_plugins$cloud2 = plugins.cloud) === null || _plugins$cloud2 === void 0 ? void 0 : _plugins$cloud2.isCloudEnabled),
          element: params.element,
          theme$: params.theme$,
          storage: new _public.Storage(window.localStorage),
          setBreadcrumbs: params.setBreadcrumbs,
          history: params.history,
          actionTypeRegistry,
          ruleTypeRegistry,
          alertsTableConfigurationRegistry,
          kibanaFeatures
        });
      }
    });
    if (this.experimentalFeatures.internalAlertsTable) {
      (0, _register_alerts_table_configuration.registerAlertsTableConfiguration)({
        alertsTableConfigurationRegistry: this.alertsTableConfigurationRegistry
      });
    }
    return {
      actionTypeRegistry: this.actionTypeRegistry,
      ruleTypeRegistry: this.ruleTypeRegistry,
      alertsTableConfigurationRegistry: this.alertsTableConfigurationRegistry
    };
  }
  start() {
    return {
      actionTypeRegistry: this.actionTypeRegistry,
      ruleTypeRegistry: this.ruleTypeRegistry,
      alertsTableConfigurationRegistry: this.alertsTableConfigurationRegistry,
      getActionForm: props => {
        return (0, _get_action_form.getActionFormLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getAddConnectorFlyout: props => {
        return (0, _get_add_connector_flyout.getAddConnectorFlyoutLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getEditConnectorFlyout: props => {
        return (0, _get_edit_connector_flyout.getEditConnectorFlyoutLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getAddRuleFlyout: props => {
        return (0, _get_add_rule_flyout.getAddRuleFlyoutLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          ruleTypeRegistry: this.ruleTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getEditRuleFlyout: props => {
        return (0, _get_edit_rule_flyout.getEditRuleFlyoutLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          ruleTypeRegistry: this.ruleTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getAlertsStateTable: props => {
        return (0, _get_alerts_table_state.getAlertsTableStateLazy)(props);
      },
      getAlertsSearchBar: props => {
        return (0, _get_alerts_search_bar.getAlertsSearchBarLazy)(props);
      },
      getAlertsTable: props => {
        return (0, _get_alerts_table.getAlertsTableLazy)(props);
      },
      getFieldBrowser: props => {
        return (0, _get_field_browser.getFieldBrowserLazy)(props);
      },
      getRuleStatusDropdown: props => {
        return (0, _get_rule_status_dropdown.getRuleStatusDropdownLazy)(props);
      },
      getRuleTagFilter: props => {
        return (0, _get_rule_tag_filter.getRuleTagFilterLazy)(props);
      },
      getRuleStatusFilter: props => {
        return (0, _get_rule_status_filter.getRuleStatusFilterLazy)(props);
      },
      getRuleTagBadge: props => {
        return (0, _get_rule_tag_badge.getRuleTagBadgeLazy)(props);
      },
      getRuleEventLogList: props => {
        return (0, _get_rule_event_log_list.getRuleEventLogListLazy)(props);
      },
      getRulesListNotifyBadge: props => {
        return (0, _get_rules_list_notify_badge.getRulesListNotifyBadgeLazy)(props);
      },
      getRulesList: props => {
        return (0, _get_rules_list.getRulesListLazy)({
          connectorServices: this.connectorServices,
          rulesListProps: props
        });
      },
      getRuleDefinition: props => {
        return (0, _get_rule_definition.getRuleDefinitionLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          ruleTypeRegistry: this.ruleTypeRegistry
        });
      },
      getRuleStatusPanel: props => {
        return (0, _get_rule_status_panel.getRuleStatusPanelLazy)(props);
      },
      getAlertSummaryWidget: props => {
        return (0, _get_rule_alerts_summary.getAlertSummaryWidgetLazy)(props);
      },
      getRuleSnoozeModal: props => {
        return (0, _get_rule_snooze_modal.getRuleSnoozeModalLazy)(props);
      },
      getRulesSettingsLink: () => {
        return (0, _get_rules_settings_link.getRulesSettingsLinkLazy)();
      }
    };
  }
  stop() {}
}
exports.Plugin = Plugin;