"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TypeRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "objectTypes", new Map());
  }
  /**
   * Returns if the object type registry has the given type registered
   */
  has(id) {
    return this.objectTypes.has(id);
  }

  /**
   * Registers an object type to the type registry
   */
  register(objectType) {
    if (this.has(objectType.id)) {
      throw new Error(_i18n.i18n.translate('xpack.triggersActionsUI.typeRegistry.register.duplicateObjectTypeErrorMessage', {
        defaultMessage: 'Object type "{id}" is already registered.',
        values: {
          id: objectType.id
        }
      }));
    }
    this.objectTypes.set(objectType.id, objectType);
  }

  /**
   * Returns an object type, throw error if not registered
   */
  get(id) {
    if (!this.has(id)) {
      throw new Error(_i18n.i18n.translate('xpack.triggersActionsUI.typeRegistry.get.missingActionTypeErrorMessage', {
        defaultMessage: 'Object type "{id}" is not registered.',
        values: {
          id
        }
      }));
    }
    return this.objectTypes.get(id);
  }
  list() {
    return Array.from(this.objectTypes).map(([id, objectType]) => objectType);
  }
}
exports.TypeRegistry = TypeRegistry;