"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleTagFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOptionDataTestSubj = tag => `ruleTagFilterOption-${tag}`;
const RuleTagFilter = props => {
  const {
    tags = [],
    selectedTags = [],
    isGrouped = false,
    isLoading = false,
    loadingMessage,
    noMatchesMessage,
    emptyMessage,
    errorMessage,
    dataTestSubj = 'ruleTagFilter',
    selectableDataTestSubj = 'ruleTagFilterSelectable',
    optionDataTestSubj = getOptionDataTestSubj,
    buttonDataTestSubj = 'ruleTagFilterButton',
    onChange = () => {}
  } = props;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const allTags = (0, _react.useMemo)(() => {
    return [...new Set([...tags, ...selectedTags])].sort();
  }, [tags, selectedTags]);
  const options = (0, _react.useMemo)(() => allTags.map(tag => ({
    label: tag,
    checked: selectedTags.includes(tag) ? 'on' : undefined,
    'data-test-subj': optionDataTestSubj(tag)
  })), [allTags, selectedTags, optionDataTestSubj]);
  const onChangeInternal = (0, _react.useCallback)(newOptions => {
    const newSelectedTags = newOptions.reduce((result, option) => {
      if (option.checked === 'on') {
        result = [...result, option.label];
      }
      return result;
    }, []);
    onChange(newSelectedTags);
  }, [onChange]);
  const onClosePopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const renderButton = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": buttonDataTestSubj,
      iconType: "arrowDown",
      hasActiveFilters: selectedTags.length > 0,
      numActiveFilters: selectedTags.length,
      numFilters: selectedTags.length,
      onClick: onClosePopover
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.ruleTagFilterButton",
      defaultMessage: "Tags"
    }));
  };
  const Container = (0, _react.useMemo)(() => {
    if (isGrouped) {
      return _react.default.Fragment;
    }
    return _eui.EuiFilterGroup;
  }, [isGrouped]);
  return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": dataTestSubj,
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    button: renderButton()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    "data-test-subj": selectableDataTestSubj,
    isLoading: isLoading,
    options: options,
    loadingMessage: loadingMessage,
    noMatchesMessage: noMatchesMessage,
    emptyMessage: emptyMessage,
    errorMessage: errorMessage,
    onChange: onChangeInternal
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), list))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleTagFilter = RuleTagFilter;