"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleConditionsGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleConditionsGroup = ({
  actionGroup,
  onResetConditionsFor,
  children,
  ...otherProps
}) => {
  if (!actionGroup) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("strong", null, actionGroup.name)),
    fullWidth: true,
    labelAppend: onResetConditionsFor && !actionGroup.isRequired && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "minusInCircle",
      color: "danger",
      "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.conditions.removeConditionLabel', {
        defaultMessage: 'Remove'
      }),
      onClick: () => onResetConditionsFor(actionGroup)
    })
  }, /*#__PURE__*/_react.default.isValidElement(children) ? /*#__PURE__*/_react.default.cloneElement(_react.default.Children.only(children), {
    actionGroup,
    ...otherProps
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleConditionsGroup = RuleConditionsGroup;