"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _types = require("../../../types");
var _rule_form = require("./rule_form");
var _rule_errors = require("./rule_errors");
var _rule_reducer = require("./rule_reducer");
var _create = require("../../lib/rule_api/create");
var _rule_types = require("../../lib/rule_api/rule_types");
var _health_check = require("../../components/health_check");
var _confirm_rule_save = require("./confirm_rule_save");
var _confirm_rule_close = require("./confirm_rule_close");
var _capabilities = require("../../lib/capabilities");
var _rule_add_footer = _interopRequireDefault(require("./rule_add_footer"));
var _health_context = require("../../context/health_context");
var _kibana = require("../../../common/lib/kibana");
var _has_rule_changed = require("./has_rule_changed");
var _value_validators = require("../../lib/value_validators");
var _constants = require("../../constants");
var _config_api = require("../../../common/lib/config_api");
var _get_initial_interval = require("./get_initial_interval");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleAdd = ({
  consumer,
  ruleTypeRegistry,
  actionTypeRegistry,
  onClose,
  canChangeTrigger,
  ruleTypeId,
  initialValues,
  reloadRules,
  onSave,
  hideInterval,
  metadata: initialMetadata,
  filteredRuleTypes,
  ...props
}) => {
  var _rule$actions;
  const onSaveHandler = onSave !== null && onSave !== void 0 ? onSave : reloadRules;
  const [metadata, setMetadata] = (0, _react.useState)(initialMetadata);
  const onChangeMetaData = (0, _react.useCallback)(newMetadata => setMetadata(newMetadata), []);
  const initialRule = (0, _react.useMemo)(() => {
    return {
      params: {},
      consumer,
      ruleTypeId,
      schedule: {
        interval: _constants.DEFAULT_RULE_INTERVAL
      },
      actions: [],
      tags: [],
      ...(initialValues ? initialValues : {})
    };
  }, [ruleTypeId, consumer, initialValues]);
  const [{
    rule
  }, dispatch] = (0, _react.useReducer)(_rule_reducer.ruleReducer, {
    rule: initialRule
  });
  const [config, setConfig] = (0, _react.useState)({
    isUsingSecurity: false
  });
  const [initialRuleParams, setInitialRuleParams] = (0, _react.useState)({});
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [isConfirmRuleSaveModalOpen, setIsConfirmRuleSaveModalOpen] = (0, _react.useState)(false);
  const [isConfirmRuleCloseModalOpen, setIsConfirmRuleCloseModalOpen] = (0, _react.useState)(false);
  const [ruleTypeIndex, setRuleTypeIndex] = (0, _react.useState)(props.ruleTypeIndex);
  const [changedFromDefaultInterval, setChangedFromDefaultInterval] = (0, _react.useState)(false);
  const setRule = value => {
    dispatch({
      command: {
        type: 'setRule'
      },
      payload: {
        key: 'rule',
        value
      }
    });
  };
  const setRuleProperty = (key, value) => {
    dispatch({
      command: {
        type: 'setProperty'
      },
      payload: {
        key,
        value
      }
    });
  };
  const {
    http,
    notifications: {
      toasts
    },
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const canShowActions = (0, _capabilities.hasShowActionsCapability)(capabilities);
  (0, _react.useEffect)(() => {
    (async () => {
      setConfig(await (0, _config_api.triggersActionsUiConfig)({
        http
      }));
    })();
  }, [http]);
  (0, _react.useEffect)(() => {
    if (ruleTypeId) {
      setRuleProperty('ruleTypeId', ruleTypeId);
    }
  }, [ruleTypeId]);
  (0, _react.useEffect)(() => {
    if (!props.ruleTypeIndex) {
      (async () => {
        const ruleTypes = await (0, _rule_types.loadRuleTypes)({
          http
        });
        const index = new Map();
        for (const ruleType of ruleTypes) {
          index.set(ruleType.id, ruleType);
        }
        setRuleTypeIndex(index);
      })();
    }
  }, [props.ruleTypeIndex, http]);
  (0, _react.useEffect)(() => {
    if ((0, _lodash.isEmpty)(rule.params) && !(0, _lodash.isEmpty)(initialRuleParams)) {
      // rule params are explicitly cleared when the rule type is cleared.
      // clear the "initial" params in order to capture the
      // default when a new rule type is selected
      setInitialRuleParams({});
    } else if ((0, _lodash.isEmpty)(initialRuleParams)) {
      // captures the first change to the rule params,
      // when consumers set a default value for the rule params
      setInitialRuleParams(rule.params);
    }
  }, [rule.params, initialRuleParams]);
  const [ruleActionsErrors, setRuleActionsErrors] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    (async () => {
      setIsLoading(true);
      const res = await (0, _rule_errors.getRuleActionErrors)(rule.actions, actionTypeRegistry);
      setIsLoading(false);
      setRuleActionsErrors([...res]);
    })();
  }, [rule.actions, actionTypeRegistry]);
  (0, _react.useEffect)(() => {
    var _initialValues$schedu;
    if (config.minimumScheduleInterval && !(initialValues !== null && initialValues !== void 0 && (_initialValues$schedu = initialValues.schedule) !== null && _initialValues$schedu !== void 0 && _initialValues$schedu.interval)) {
      setRuleProperty('schedule', {
        interval: (0, _get_initial_interval.getInitialInterval)(config.minimumScheduleInterval.value)
      });
    }
  }, [config.minimumScheduleInterval, initialValues]);
  (0, _react.useEffect)(() => {
    if (rule.ruleTypeId && ruleTypeIndex) {
      const type = ruleTypeIndex.get(rule.ruleTypeId);
      if (type !== null && type !== void 0 && type.defaultScheduleInterval && !changedFromDefaultInterval) {
        setRuleProperty('schedule', {
          interval: type.defaultScheduleInterval
        });
      }
    }
  }, [rule.ruleTypeId, ruleTypeIndex, rule.schedule.interval, changedFromDefaultInterval]);
  (0, _react.useEffect)(() => {
    if (rule.schedule.interval !== _constants.DEFAULT_RULE_INTERVAL && !changedFromDefaultInterval) {
      setChangedFromDefaultInterval(true);
    }
  }, [rule.schedule.interval, changedFromDefaultInterval]);
  const checkForChangesAndCloseFlyout = () => {
    if ((0, _has_rule_changed.hasRuleChanged)(rule, initialRule, false) || (0, _has_rule_changed.haveRuleParamsChanged)(rule.params, initialRuleParams)) {
      setIsConfirmRuleCloseModalOpen(true);
    } else {
      onClose(_types.RuleFlyoutCloseReason.CANCELED, metadata);
    }
  };
  const saveRuleAndCloseFlyout = async () => {
    const savedRule = await onSaveRule();
    setIsSaving(false);
    if (savedRule) {
      onClose(_types.RuleFlyoutCloseReason.SAVED, metadata);
      if (onSaveHandler) {
        onSaveHandler(metadata);
      }
    }
  };
  const ruleType = rule.ruleTypeId ? ruleTypeRegistry.get(rule.ruleTypeId) : null;
  const {
    ruleBaseErrors,
    ruleErrors,
    ruleParamsErrors
  } = (0, _react.useMemo)(() => (0, _rule_errors.getRuleErrors)(rule, ruleType, config), [rule, ruleType, config]);

  // Confirm before saving if user is able to add actions but hasn't added any to this rule
  const shouldConfirmSave = canShowActions && ((_rule$actions = rule.actions) === null || _rule$actions === void 0 ? void 0 : _rule$actions.length) === 0;
  async function onSaveRule() {
    try {
      const newRule = await (0, _create.createRule)({
        http,
        rule: rule
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleAdd.saveSuccessNotificationText', {
        defaultMessage: 'Created rule "{ruleName}"',
        values: {
          ruleName: newRule.name
        }
      }));
      return newRule;
    } catch (errorRes) {
      var _errorRes$body$messag, _errorRes$body;
      toasts.addDanger((_errorRes$body$messag = (_errorRes$body = errorRes.body) === null || _errorRes$body === void 0 ? void 0 : _errorRes$body.message) !== null && _errorRes$body$messag !== void 0 ? _errorRes$body$messag : _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleAdd.saveErrorNotificationText', {
        defaultMessage: 'Cannot create rule.'
      }));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: checkForChangesAndCloseFlyout,
    "aria-labelledby": "flyoutRuleAddTitle",
    size: "m",
    maxWidth: 620,
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "addRuleFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Create rule",
    id: "xpack.triggersActionsUI.sections.ruleAdd.flyoutTitle"
  })))), /*#__PURE__*/_react.default.createElement(_health_context.HealthContextProvider, null, /*#__PURE__*/_react.default.createElement(_health_check.HealthCheck, {
    inFlyout: true,
    waitForCheck: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_rule_form.RuleForm, {
    rule: rule,
    config: config,
    dispatch: dispatch,
    errors: ruleErrors,
    canChangeTrigger: canChangeTrigger,
    operation: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleAdd.operationName', {
      defaultMessage: 'create'
    }),
    actionTypeRegistry: actionTypeRegistry,
    ruleTypeRegistry: ruleTypeRegistry,
    metadata: metadata,
    filteredRuleTypes: filteredRuleTypes,
    hideInterval: hideInterval,
    onChangeMetaData: onChangeMetaData
  })), /*#__PURE__*/_react.default.createElement(_rule_add_footer.default, {
    isSaving: isSaving,
    isFormLoading: isLoading,
    onSave: async () => {
      setIsSaving(true);
      if (isLoading || !(0, _rule_errors.isValidRule)(rule, ruleErrors, ruleActionsErrors)) {
        setRule((0, _value_validators.getRuleWithInvalidatedFields)(rule, ruleParamsErrors, ruleBaseErrors, ruleActionsErrors));
        setIsSaving(false);
        return;
      }
      if (shouldConfirmSave) {
        setIsConfirmRuleSaveModalOpen(true);
      } else {
        await saveRuleAndCloseFlyout();
      }
    },
    onCancel: checkForChangesAndCloseFlyout
  }))), isConfirmRuleSaveModalOpen && /*#__PURE__*/_react.default.createElement(_confirm_rule_save.ConfirmRuleSave, {
    onConfirm: async () => {
      setIsConfirmRuleSaveModalOpen(false);
      await saveRuleAndCloseFlyout();
    },
    onCancel: () => {
      setIsSaving(false);
      setIsConfirmRuleSaveModalOpen(false);
    }
  }), isConfirmRuleCloseModalOpen && /*#__PURE__*/_react.default.createElement(_confirm_rule_close.ConfirmRuleClose, {
    onConfirm: () => {
      setIsConfirmRuleCloseModalOpen(false);
      onClose(_types.RuleFlyoutCloseReason.CANCELED, metadata);
    },
    onCancel: () => {
      setIsConfirmRuleCloseModalOpen(false);
    }
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = RuleAdd;
module.exports = exports.default;