"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasRuleChanged = hasRuleChanged;
exports.haveRuleParamsChanged = haveRuleParamsChanged;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEEP_COMPARE_FIELDS = ['tags', 'schedule', 'actions'];
function getNonNullCompareFields(rule) {
  const {
    name,
    ruleTypeId,
    throttle,
    notifyWhen
  } = rule;
  return {
    ...(!!(name && name.length > 0) ? {
      name
    } : {}),
    ...(!!(ruleTypeId && ruleTypeId.length > 0) ? {
      ruleTypeId
    } : {}),
    ...(!!(throttle && throttle.length > 0) ? {
      throttle
    } : {}),
    ...(!!(notifyWhen && notifyWhen.length > 0) ? {
      notifyWhen
    } : {})
  };
}
function hasRuleChanged(a, b, compareParams) {
  // Deep compare these fields
  let objectsAreEqual = (0, _fastDeepEqual.default)((0, _lodash.pick)(a, DEEP_COMPARE_FIELDS), (0, _lodash.pick)(b, DEEP_COMPARE_FIELDS));
  if (compareParams) {
    objectsAreEqual = objectsAreEqual && (0, _fastDeepEqual.default)(a.params, b.params);
  }
  const nonNullCompareFieldsAreEqual = (0, _fastDeepEqual.default)(getNonNullCompareFields(a), getNonNullCompareFields(b));
  return !objectsAreEqual || !nonNullCompareFieldsAreEqual;
}
function haveRuleParamsChanged(a, b) {
  return !(0, _fastDeepEqual.default)(a, b);
}