"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleEventLogList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _rule_execution_summary_and_chart = require("./rule_execution_summary_and_chart");
var _rule_event_log_list_table = require("./rule_event_log_list_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_EVENT_LOG_LIST_STORAGE_KEY = 'xpack.triggersActionsUI.ruleEventLogList.initialColumns';
const ruleEventListContainerStyle = {
  minHeight: 400
};
const RuleEventLogList = props => {
  const {
    ruleId,
    ruleType,
    localStorageKey = RULE_EVENT_LOG_LIST_STORAGE_KEY,
    refreshToken,
    requestRefresh,
    fetchRuleSummary = true,
    loadExecutionLogAggregations
  } = props;
  const {
    ruleSummary,
    numberOfExecutions,
    onChangeDuration,
    isLoadingRuleSummary = false
  } = props;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: ruleEventListContainerStyle,
    "data-test-subj": "ruleEventLogListContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_rule_execution_summary_and_chart.RuleExecutionSummaryAndChartWithApi, {
    ruleId: ruleId,
    ruleType: ruleType,
    ruleSummary: ruleSummary,
    numberOfExecutions: numberOfExecutions,
    isLoadingRuleSummary: isLoadingRuleSummary,
    refreshToken: refreshToken,
    onChangeDuration: onChangeDuration,
    requestRefresh: requestRefresh,
    fetchRuleSummary: fetchRuleSummary
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_rule_event_log_list_table.RuleEventLogListTableWithApi, {
    localStorageKey: localStorageKey,
    ruleId: ruleId,
    refreshToken: refreshToken,
    overrideLoadExecutionLogAggregations: loadExecutionLogAggregations
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleEventLogList = RuleEventLogList;