"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleErrorLogWithApi = exports.RuleErrorLog = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _refine_search_prompt = require("../../common/components/refine_search_prompt");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _event_log = require("../../common/components/event_log");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParsedDate = date => {
  if (date.includes('now')) {
    var _datemath$parse;
    return ((_datemath$parse = _datemath.default.parse(date)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.format()) || date;
  }
  return date;
};
const API_FAILED_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.errorLogColumn.apiError', {
  defaultMessage: 'Failed to fetch error log'
});
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.errorLogColumn.searchPlaceholder', {
  defaultMessage: 'Search error log message'
});
const updateButtonProps = {
  iconOnly: true,
  fill: false
};
const MAX_RESULTS = 1000;
const RuleErrorLog = props => {
  const {
    ruleId,
    runId,
    loadActionErrorLog,
    refreshToken,
    spaceId,
    logFromDifferentSpace
  } = props;
  const {
    uiSettings,
    notifications
  } = (0, _kibana.useKibana)().services;

  // Data grid states
  const [logs, setLogs] = (0, _react.useState)([]);
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: 10,
    totalItemCount: 0
  });
  const [sort, setSort] = (0, _react.useState)({
    field: 'timestamp',
    direction: 'desc'
  });
  const [searchText, setSearchText] = (0, _react.useState)('');
  const [search, setSearch] = (0, _react.useState)('');

  // Date related states
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [dateStart, setDateStart] = (0, _react.useState)('now-24h');
  const [dateEnd, setDateEnd] = (0, _react.useState)('now');
  const [dateFormat] = (0, _react.useState)(() => uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('dateFormat'));
  const [commonlyUsedRanges] = (0, _react.useState)(() => {
    var _uiSettings$get;
    return (uiSettings === null || uiSettings === void 0 ? void 0 : (_uiSettings$get = uiSettings.get('timepicker:quickRanges')) === null || _uiSettings$get === void 0 ? void 0 : _uiSettings$get.map(({
      from,
      to,
      display
    }) => ({
      start: from,
      end: to,
      label: display
    }))) || [];
  });
  const [actualTotalItemCount, setActualTotalItemCount] = (0, _react.useState)(0);
  const isInitialized = (0, _react.useRef)(false);
  const isOnLastPage = (0, _react.useMemo)(() => {
    const {
      pageIndex,
      pageSize
    } = pagination;
    return (pageIndex + 1) * pageSize >= MAX_RESULTS;
  }, [pagination]);
  const formattedSort = (0, _react.useMemo)(() => {
    if (!sort) {
      return;
    }
    const {
      field,
      direction
    } = sort;
    return [{
      [field]: {
        order: direction
      }
    }];
  }, [sort]);
  const loadEventLogs = async () => {
    setIsLoading(true);
    try {
      const result = await loadActionErrorLog({
        id: ruleId,
        runId,
        message: searchText,
        dateStart: getParsedDate(dateStart),
        dateEnd: getParsedDate(dateEnd),
        page: pagination.pageIndex,
        perPage: pagination.pageSize,
        sort: formattedSort,
        namespace: spaceId,
        withAuth: logFromDifferentSpace
      });
      setLogs(result.errors);
      setPagination({
        ...pagination,
        totalItemCount: Math.min(result.totalErrors, MAX_RESULTS)
      });
      setActualTotalItemCount(result.totalErrors);
    } catch (e) {
      notifications.toasts.addDanger({
        title: API_FAILED_MESSAGE,
        text: e.body.message
      });
    }
    setIsLoading(false);
  };
  const onTimeChange = (0, _react.useCallback)(({
    start,
    end,
    isInvalid
  }) => {
    if (isInvalid) {
      return;
    }
    setDateStart(start);
    setDateEnd(end);
  }, [setDateStart, setDateEnd]);
  const onSearchChange = (0, _react.useCallback)(e => {
    if (e.target.value === '') {
      setSearchText('');
    }
    setSearch(e.target.value);
  }, [setSearchText, setSearch]);
  const onKeyUp = (0, _react.useCallback)(e => {
    if (e.key === 'Enter') {
      setSearchText(search);
    }
  }, [search, setSearchText]);
  const onRefresh = () => {
    loadEventLogs();
  };
  const columns = (0, _react.useMemo)(() => [{
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.errorLogColumn.timestamp', {
      defaultMessage: 'Timestamp'
    }),
    render: date => /*#__PURE__*/_react.default.createElement(_event_log.EventLogListCellRenderer, {
      columnId: "timestamp",
      value: date,
      dateFormat: dateFormat
    }),
    sortable: true,
    width: '250px'
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.errorLogColumn.type', {
      defaultMessage: 'Type'
    }),
    sortable: false,
    width: '100px'
  }, {
    field: 'message',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.errorLogColumn.message', {
      defaultMessage: 'Message'
    }),
    sortable: false
  }], [dateFormat]);
  (0, _react.useEffect)(() => {
    loadEventLogs();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dateStart, dateEnd, formattedSort, pagination.pageIndex, pagination.pageSize, searchText, runId]);
  (0, _react.useEffect)(() => {
    if (isInitialized.current) {
      loadEventLogs();
    }
    isInitialized.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refreshToken]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, runId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    isClearable: true,
    value: search,
    onChange: onSearchChange,
    onKeyUp: onKeyUp,
    placeholder: SEARCH_PLACEHOLDER
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    "data-test-subj": "ruleEventLogListDatePicker",
    width: "auto",
    isLoading: isLoading,
    start: dateStart,
    end: dateEnd,
    onTimeChange: onTimeChange,
    onRefresh: onRefresh,
    dateFormat: dateFormat,
    commonlyUsedRanges: commonlyUsedRanges,
    updateButtonProps: updateButtonProps
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    "data-test-subj": "ruleEventLogListProgressBar"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "RuleErrorLog",
    loading: isLoading,
    items: logs !== null && logs !== void 0 ? logs : [],
    columns: columns,
    sorting: {
      sort
    },
    pagination: pagination,
    onChange: ({
      page: changedPage,
      sort: changedSort
    }) => {
      if (changedPage) {
        setPagination(prevPagination => {
          if (prevPagination.pageIndex !== changedPage.index || prevPagination.pageSize !== changedPage.size) {
            return {
              ...prevPagination,
              pageIndex: changedPage.index,
              pageSize: changedPage.size
            };
          }
          return prevPagination;
        });
      }
      if (changedSort) {
        setSort(prevSort => {
          if ((prevSort === null || prevSort === void 0 ? void 0 : prevSort.direction) !== changedSort.direction) {
            return changedSort;
          }
          return prevSort;
        });
      }
    }
  }), isOnLastPage && /*#__PURE__*/_react.default.createElement(_refine_search_prompt.RefineSearchPrompt, {
    documentSize: actualTotalItemCount,
    visibleDocumentSize: MAX_RESULTS,
    backToTopAnchor: "rule_error_log_list"
  }));
};
exports.RuleErrorLog = RuleErrorLog;
const RuleErrorLogWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleErrorLog);

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleErrorLogWithApi = RuleErrorLogWithApi;