"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsWithApi = exports.RuleDetails = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/alerting-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _update_api_key_modal_confirmation = require("../../../components/update_api_key_modal_confirmation");
var _update_api_key = require("../../../lib/rule_api/update_api_key");
var _rules_delete_modal_confirmation = require("../../../components/rules_delete_modal_confirmation");
var _rule_actions_popover = require("./rule_actions_popover");
var _capabilities = require("../../../lib/capabilities");
var _breadcrumb = require("../../../lib/breadcrumb");
var _doc_title = require("../../../lib/doc_title");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _rule_route = require("./rule_route");
var _view_in_app = require("./view_in_app");
var _rule_form = require("../../rule_form");
var _constants = require("../../../constants");
var _translations = require("../../rules_list/translations");
var _kibana = require("../../../../common/lib/kibana");
var _rule_reducer = require("../../rule_form/rule_reducer");
var _action_connector_api = require("../../../lib/action_connector_api");
var _config_api = require("../../../../common/lib/config_api");
var _run_rule = require("../../../lib/run_rule");
var _use_bulk_operation_toast = require("../../../hooks/use_bulk_operation_toast");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleDetailStyle = {
  minWidth: 0
};
const RuleDetails = ({
  rule,
  ruleType,
  actionTypes,
  bulkDisableRules,
  bulkEnableRules,
  bulkDeleteRules,
  snoozeRule,
  unsnoozeRule,
  requestRefresh,
  refreshToken
}) => {
  var _rule$executionStatus, _rule$executionStatus2, _rule$executionStatus3;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    application: {
      capabilities
    },
    ruleTypeRegistry,
    actionTypeRegistry,
    setBreadcrumbs,
    chrome,
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [{}, dispatch] = (0, _react.useReducer)(_rule_reducer.ruleReducer, {
    rule
  });
  const setInitialRule = value => {
    dispatch({
      command: {
        type: 'setRule'
      },
      payload: {
        key: 'rule',
        value
      }
    });
  };
  const [rulesToDelete, setRulesToDelete] = (0, _react.useState)([]);
  const [rulesToUpdateAPIKey, setRulesToUpdateAPIKey] = (0, _react.useState)([]);
  const [hasActionsWithBrokenConnector, setHasActionsWithBrokenConnector] = (0, _react.useState)(false);
  const [config, setConfig] = (0, _react.useState)({
    isUsingSecurity: false
  });
  (0, _react.useEffect)(() => {
    (async () => {
      setConfig(await (0, _config_api.triggersActionsUiConfig)({
        http
      }));
    })();
  }, [http]);

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)('rules', true), {
      text: rule.name
    }]);
    chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)('rules'));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // Determine if any attached action has an issue with its connector
  (0, _react.useEffect)(() => {
    (async () => {
      let loadedConnectors = [];
      try {
        loadedConnectors = await (0, _action_connector_api.loadAllActions)({
          http
        });
      } catch (err) {
        loadedConnectors = [];
      }
      if (loadedConnectors.length > 0) {
        const hasActionWithBrokenConnector = rule.actions.some(action => !loadedConnectors.find(connector => connector.id === action.id));
        if (setHasActionsWithBrokenConnector) {
          setHasActionsWithBrokenConnector(hasActionWithBrokenConnector);
        }
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const canExecuteActions = (0, _capabilities.hasExecuteActionsCapability)(capabilities);
  const canSaveRule = (0, _capabilities.hasAllPrivilege)(rule.consumer, ruleType) && (
  // if the rule has actions, can the user save the rule's action params
  canExecuteActions || !canExecuteActions && rule.actions.length === 0);
  const hasEditButton =
  // can the user save the rule
  canSaveRule && (
  // is this rule type editable from within Rules Management
  ruleTypeRegistry.has(rule.ruleTypeId) ? !ruleTypeRegistry.get(rule.ruleTypeId).requiresAppContext : false);
  const [editFlyoutVisible, setEditFlyoutVisibility] = (0, _react.useState)(false);
  const onRunRule = async id => {
    await (0, _run_rule.runRule)(http, toasts, id);
  };

  // Check whether interval is below configured minium
  (0, _react.useEffect)(() => {
    if (rule.schedule.interval && config.minimumScheduleInterval) {
      if ((0, _common.parseDuration)(rule.schedule.interval) < (0, _common.parseDuration)(config.minimumScheduleInterval.value)) {
        const configurationToast = toasts.addInfo({
          'data-test-subj': 'intervalConfigToast',
          title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.scheduleIntervalToastTitle', {
            defaultMessage: 'Configuration settings'
          }),
          text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.triggersActionsUI.sections.ruleDetails.scheduleIntervalToastMessage",
            defaultMessage: "This rule has an interval set below the minimum configured interval. This may impact performance."
          })), hasEditButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexEnd",
            gutterSize: "s"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            "data-test-subj": "ruleIntervalToastEditButton",
            onClick: () => {
              toasts.remove(configurationToast);
              setEditFlyoutVisibility(true);
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.triggersActionsUI.sections.ruleDetails.scheduleIntervalToastMessageButton",
            defaultMessage: "Edit rule"
          }))))))
        });
      }
    }
  }, [rule.schedule.interval, config.minimumScheduleInterval, toasts, hasEditButton]);
  const setRule = async () => {
    history.push((0, _ruleDataUtils.getRuleDetailsRoute)(rule.id));
  };
  const goToRulesList = () => {
    history.push(_constants.routeToRules);
  };
  const getRuleStatusErrorReasonText = () => {
    if (rule.executionStatus.error && rule.executionStatus.error.reason) {
      return _translations.rulesErrorReasonTranslationsMapping[rule.executionStatus.error.reason];
    } else {
      return _translations.rulesErrorReasonTranslationsMapping.unknown;
    }
  };
  const getRuleStatusWarningReasonText = () => {
    if (rule.executionStatus.warning && rule.executionStatus.warning.reason) {
      return _translations.rulesWarningReasonTranslationsMapping[rule.executionStatus.warning.reason];
    } else {
      return _translations.rulesWarningReasonTranslationsMapping.unknown;
    }
  };
  const editButton = hasEditButton ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "openEditRuleFlyoutButton",
    iconType: "pencil",
    onClick: () => setEditFlyoutVisibility(true),
    name: "edit",
    disabled: !ruleType.enabledInLicense
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.editRuleButtonLabel",
    defaultMessage: "Edit"
  })), editFlyoutVisible && /*#__PURE__*/_react.default.createElement(_rule_form.RuleEdit, {
    initialRule: rule,
    onClose: () => {
      setInitialRule(rule);
      setEditFlyoutVisibility(false);
    },
    actionTypeRegistry: actionTypeRegistry,
    ruleTypeRegistry: ruleTypeRegistry,
    ruleType: ruleType,
    onSave: setRule
  })) : null;
  const [isDeleteModalFlyoutVisible, setIsDeleteModalVisibility] = (0, _react.useState)(false);
  const {
    showToast
  } = (0, _use_bulk_operation_toast.useBulkOperationToast)({});
  const onDeleteConfirm = async () => {
    setIsDeleteModalVisibility(false);
    const {
      errors,
      total
    } = await bulkDeleteRules({
      ids: rulesToDelete
    });
    showToast({
      action: 'DELETE',
      errors,
      total
    });
    setRulesToDelete([]);
    goToRulesList();
  };
  const onDeleteCancel = () => {
    setIsDeleteModalVisibility(false);
    setRulesToDelete([]);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleteModalFlyoutVisible && /*#__PURE__*/_react.default.createElement(_rules_delete_modal_confirmation.RulesDeleteModalConfirmation, {
    onConfirm: onDeleteConfirm,
    onCancel: onDeleteCancel,
    confirmButtonText: (0, _translations.getConfirmDeletionButtonText)(rulesToDelete.length, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE),
    confirmModalText: (0, _translations.getConfirmDeletionModalText)(rulesToDelete.length, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE)
  }), /*#__PURE__*/_react.default.createElement(_update_api_key_modal_confirmation.UpdateApiKeyModalConfirmation, {
    onCancel: () => {
      setRulesToUpdateAPIKey([]);
    },
    idsToUpdate: rulesToUpdateAPIKey,
    apiUpdateApiKeyCall: _update_api_key.bulkUpdateAPIKey,
    setIsLoadingState: () => {},
    onUpdated: async () => {
      setRulesToUpdateAPIKey([]);
      requestRefresh();
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "ruleDetailsTitle",
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleDetails.ruleDetailsTitle",
      defaultMessage: "{ruleName}",
      values: {
        ruleName: rule.name
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.ruleTypeTitle",
      defaultMessage: "Type"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "ruleTypeLabel"
    }, ruleType.name)))), (0, _capabilities.hasManageApiKeysCapability)(capabilities) && rule.apiKeyOwner && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.rulesListTable.columns.apiKeyOwnerTitle",
      defaultMessage: "API key owner"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "apiKeyOwnerLabel"
    }, /*#__PURE__*/_react.default.createElement("b", null, rule.apiKeyOwner), rule.apiKeyCreatedByUser ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.userManagedApikey', {
        defaultMessage: 'This rule is associated with an API key.'
      })
    })) : null))))),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_rule_actions_popover.RuleActionsPopover, {
      canSaveRule: canSaveRule,
      rule: rule,
      onDelete: ruleId => {
        setIsDeleteModalVisibility(true);
        setRulesToDelete([ruleId]);
      },
      onApiKeyUpdate: ruleId => {
        setRulesToUpdateAPIKey([ruleId]);
      },
      onEnableDisable: async enable => {
        if (enable) {
          await bulkEnableRules({
            ids: [rule.id]
          });
        } else {
          await bulkDisableRules({
            ids: [rule.id]
          });
        }
        requestRefresh();
      },
      onRunRule: onRunRule
    }), editButton, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "refreshRulesButton",
      iconType: "refresh",
      onClick: requestRefresh,
      name: "refresh",
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.refreshRulesButtonLabel",
      defaultMessage: "Refresh"
    })), /*#__PURE__*/_react.default.createElement(_view_in_app.ViewInApp, {
      rule: rule
    })]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, null, rule.enabled && ((_rule$executionStatus = rule.executionStatus.error) === null || _rule$executionStatus === void 0 ? void 0 : _rule$executionStatus.reason) === _common.RuleExecutionStatusErrorReasons.License ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": "ruleErrorBanner",
    size: "s",
    iconType: "rule"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "danger",
    type: "warning"
  }), "\xA0", /*#__PURE__*/_react.default.createElement("b", null, getRuleStatusErrorReasonText()), ",\xA0", (_rule$executionStatus2 = rule.executionStatus.error) === null || _rule$executionStatus2 === void 0 ? void 0 : _rule$executionStatus2.message, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${http.basePath.get()}/app/management/stack/license_management`,
    color: "primary",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.manageLicensePlanBannerLinkTitle",
    defaultMessage: "Manage license"
  })))))) : null, rule.enabled && rule.executionStatus.status === 'warning' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "ruleWarningBanner",
    size: "s",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "warning",
    type: "warning"
  }), "\xA0", getRuleStatusWarningReasonText(), "\xA0", (_rule$executionStatus3 = rule.executionStatus.warning) === null || _rule$executionStatus3 === void 0 ? void 0 : _rule$executionStatus3.message)))) : null, hasActionsWithBrokenConnector && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "actionWithBrokenConnectorWarningBanner",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "warning",
    type: "warning"
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.actionWithBrokenConnectorWarningBannerTitle",
    defaultMessage: "There is an issue with one of the connectors associated with this rule."
  }), "\xA0", hasEditButton && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "actionWithBrokenConnectorWarningBannerEdit",
    color: "primary",
    onClick: () => setEditFlyoutVisibility(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleDetails.actionWithBrokenConnectorWarningBannerEditText",
    defaultMessage: "Edit rule"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: ruleDetailStyle
  }, /*#__PURE__*/_react.default.createElement(_rule_route.RuleRouteWithApi, {
    requestRefresh: requestRefresh,
    refreshToken: refreshToken,
    rule: rule,
    ruleType: ruleType,
    readOnly: !canSaveRule
  })))));
};
exports.RuleDetails = RuleDetails;
const RuleDetailsWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleDetails);
exports.RuleDetailsWithApi = RuleDetailsWithApi;