"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INPUT_TIMEOUT = exports.FieldBrowserComponent = exports.FieldBrowser = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _field_browser_modal = require("./field_browser_modal");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _field_browser = require("./field_browser.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELDS_BUTTON_CLASS_NAME = 'fields-button';

/** wait this many ms after the user completes typing before applying the filter input */
const INPUT_TIMEOUT = 250;

/**
 * Manages the state of the field browser
 */
exports.INPUT_TIMEOUT = INPUT_TIMEOUT;
const FieldBrowserComponent = ({
  columnIds,
  browserFields,
  onResetColumns,
  onToggleColumn,
  options,
  width
}) => {
  const initialCategories = (0, _react.useMemo)(() => {
    var _options$preselectedC;
    return (_options$preselectedC = options === null || options === void 0 ? void 0 : options.preselectedCategoryIds) !== null && _options$preselectedC !== void 0 ? _options$preselectedC : [];
  }, [options === null || options === void 0 ? void 0 : options.preselectedCategoryIds]);
  const customizeColumnsButtonRef = (0, _react.useRef)(null);
  /** all field names shown in the field browser must contain this string (when specified) */
  const [filterInput, setFilterInput] = (0, _react.useState)('');
  /** debounced filterInput, the one that is applied to the filteredBrowserFields */
  const [appliedFilterInput, setAppliedFilterInput] = (0, _react.useState)('');
  /** all fields in this collection have field names that match the filterInput */
  const [filteredBrowserFields, setFilteredBrowserFields] = (0, _react.useState)(null);
  /** when true, show only the the selected field */
  const [filterSelectedEnabled, setFilterSelectedEnabled] = (0, _react.useState)(false);
  /** when true, show a spinner in the input to indicate the field browser is searching for matching field names */
  const [isSearching, setIsSearching] = (0, _react.useState)(false);
  /** this category will be displayed in the right-hand pane of the field browser */
  const [selectedCategoryIds, setSelectedCategoryIds] = (0, _react.useState)(initialCategories);
  /** show the field browser */
  const [show, setShow] = (0, _react.useState)(false);

  // debounced function to apply the input filter
  // will delay the call to setAppliedFilterInput by INPUT_TIMEOUT ms
  // the parameter used will be the last one passed
  const debouncedApplyFilterInput = (0, _react.useMemo)(() => (0, _lodash.debounce)(input => {
    setAppliedFilterInput(input);
  }, INPUT_TIMEOUT), []);
  (0, _react.useEffect)(() => {
    return () => {
      debouncedApplyFilterInput.cancel();
    };
  }, [debouncedApplyFilterInput]);
  const selectionFilteredBrowserFields = (0, _react.useMemo)(() => filterSelectedEnabled ? (0, _helpers.filterSelectedBrowserFields)({
    browserFields,
    columnIds
  }) : browserFields, [browserFields, columnIds, filterSelectedEnabled]);
  (0, _react.useEffect)(() => {
    setFilteredBrowserFields((0, _helpers.filterBrowserFieldsByFieldName)({
      browserFields: selectionFilteredBrowserFields,
      substring: appliedFilterInput
    }));
    setIsSearching(false);
  }, [appliedFilterInput, selectionFilteredBrowserFields]);

  /** Shows / hides the field browser */
  const onShow = (0, _react.useCallback)(() => {
    setShow(true);
  }, []);

  /** Invoked when the field browser should be hidden */
  const onHide = (0, _react.useCallback)(() => {
    setFilterInput('');
    setAppliedFilterInput('');
    setFilteredBrowserFields(null);
    setFilterSelectedEnabled(false);
    setIsSearching(false);
    setSelectedCategoryIds(initialCategories);
    setShow(false);
  }, [initialCategories]);

  /** Invoked when the user types in the filter input */
  const updateFilter = (0, _react.useCallback)(newFilterInput => {
    setIsSearching(true);
    setFilterInput(newFilterInput);
    debouncedApplyFilterInput(newFilterInput);
  }, [debouncedApplyFilterInput]);

  /** Invoked when the user changes the view all/selected value  */
  const onFilterSelectedChange = (0, _react.useCallback)(filterSelected => {
    setFilterSelectedEnabled(filterSelected);
  }, [setFilterSelectedEnabled]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: _field_browser.styles.buttonContainer,
    "data-test-subj": "fields-browser-button-container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.FIELDS_BROWSER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": i18n.FIELDS_BROWSER,
    buttonRef: customizeColumnsButtonRef,
    className: FIELDS_BUTTON_CLASS_NAME,
    color: "text",
    "data-test-subj": "show-field-browser",
    iconType: "tableOfContents",
    onClick: onShow,
    size: "xs"
  }, i18n.FIELDS)), show && /*#__PURE__*/_react.default.createElement(_field_browser_modal.FieldBrowserModal, {
    columnIds: columnIds,
    filteredBrowserFields: filteredBrowserFields != null ? filteredBrowserFields : browserFields,
    filterSelectedEnabled: filterSelectedEnabled,
    isSearching: isSearching,
    setSelectedCategoryIds: setSelectedCategoryIds,
    onFilterSelectedChange: onFilterSelectedChange,
    onHide: onHide,
    onResetColumns: onResetColumns,
    onSearchInputChange: updateFilter,
    onToggleColumn: onToggleColumn,
    options: options,
    restoreFocusTo: customizeColumnsButtonRef,
    searchInput: filterInput,
    appliedFilterInput: appliedFilterInput,
    selectedCategoryIds: selectedCategoryIds,
    width: width
  }));
};
exports.FieldBrowserComponent = FieldBrowserComponent;
const FieldBrowser = /*#__PURE__*/_react.default.memo(FieldBrowserComponent);
exports.FieldBrowser = FieldBrowser;