"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleQuickEditButtonsWithApi = exports.RuleQuickEditButtons = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _with_bulk_rule_api_operations = require("./with_bulk_rule_api_operations");
require("./rule_quick_edit_buttons.scss");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleQuickEditButtons = ({
  selectedItems,
  isAllSelected = false,
  getFilter,
  onPerformingAction = noop,
  onActionPerformed = noop,
  bulkEditAction,
  isEnablingRules = false,
  isDisablingRules = false,
  isBulkEditing = false,
  updateRulesToBulkEdit,
  onEnable,
  onDisable
}) => {
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const isPerformingAction = isEnablingRules || isDisablingRules || isBulkEditing;
  const hasDisabledByLicenseRuleTypes = (0, _react.useMemo)(() => {
    if (isAllSelected) {
      return false;
    }
    return !!selectedItems.find(alertItem => !alertItem.enabledInLicense);
  }, [selectedItems, isAllSelected]);
  async function deleteSelectedItems() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'delete',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'delete',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToDeleteRulesMessage', {
          defaultMessage: 'Failed to delete rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function updateAPIKeysClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'updateApiKey',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'updateApiKey',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToUpdateRuleAPIKeysMessage', {
          defaultMessage: 'Failed to update API keys for rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function onSnoozeAllClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'snooze',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'snooze',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToSnoozeRules', {
          defaultMessage: 'Failed to snooze or unsnooze rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function onUnsnoozeAllClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'unsnooze',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'unsnooze',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToSnoozeRules', {
          defaultMessage: 'Failed to snooze or unsnooze rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function onScheduleAllClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'schedule',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'schedule',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToSnoozeRules', {
          defaultMessage: 'Failed to snooze or unsnooze rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  async function onUnscheduleAllClick() {
    onPerformingAction();
    try {
      if (isAllSelected) {
        updateRulesToBulkEdit({
          action: 'unschedule',
          filter: getFilter()
        });
      } else {
        updateRulesToBulkEdit({
          action: 'unschedule',
          rules: selectedItems
        });
      }
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.failedToSnoozeRules', {
          defaultMessage: 'Failed to snooze or unsnooze rules'
        })
      });
    } finally {
      onActionPerformed();
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    direction: "column",
    gutterSize: "none",
    "data-test-subj": "ruleQuickEditButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onSnoozeAllClick,
    isLoading: isBulkEditing && bulkEditAction === 'snooze',
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkSnooze"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.snoozeAllTitle",
    defaultMessage: "Snooze now"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onUnsnoozeAllClick,
    isLoading: isBulkEditing && bulkEditAction === 'unsnooze',
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkUnsnooze"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.unsnoozeAllTitle",
    defaultMessage: "Unsnooze now"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onScheduleAllClick,
    isLoading: isBulkEditing && bulkEditAction === 'schedule',
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkSnoozeSchedule"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.snoozeScheduleAllTitle",
    defaultMessage: "Schedule snooze"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onUnscheduleAllClick,
    isLoading: isBulkEditing && bulkEditAction === 'unschedule',
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkRemoveSnoozeSchedule"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.removeSnoozeScheduleAllTitle",
    defaultMessage: "Unschedule snooze"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onEnable,
    isLoading: isEnablingRules,
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkEnable"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.enableAllTitle",
    defaultMessage: "Enable"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onDisable,
    isLoading: isDisablingRules,
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkDisable"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.disableAllTitle",
    defaultMessage: "Disable"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: updateAPIKeysClick,
    isLoading: isBulkEditing && bulkEditAction === 'updateApiKey',
    isDisabled: isPerformingAction,
    "data-test-subj": "updateAPIKeys"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.updateRuleAPIKeysTitle",
    defaultMessage: "Update API keys"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: deleteSelectedItems,
    isLoading: isBulkEditing && bulkEditAction === 'delete',
    iconType: "trash",
    color: "danger",
    isDisabled: isPerformingAction || hasDisabledByLicenseRuleTypes,
    "data-test-subj": "bulkDelete",
    className: "actBulkActionPopover__deleteAll"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.bulkActionPopover.deleteAllTitle",
    defaultMessage: "Delete"
  }))));
};
exports.RuleQuickEditButtons = RuleQuickEditButtons;
const RuleQuickEditButtonsWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleQuickEditButtons);
exports.RuleQuickEditButtonsWithApi = RuleQuickEditButtonsWithApi;
function noop() {}