"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolbarVisibility = void 0;
var _react = _interopRequireWildcard(require("react"));
var _alerts_count = require("./components/alerts_count/alerts_count");
var _last_updated_at = require("./components/last_updated_at");
var _field_browser = require("../../field_browser");
var _inspect = require("./components/inspect");
var _translations = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const BulkActionsToolbar = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../bulk_actions/components/toolbar'))));
const rightControl = ({
  controls,
  updatedAt,
  getInspectQuery,
  showInspectButton
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showInspectButton && /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    inspectTitle: _translations.ALERTS_TABLE_TITLE,
    getInspectQuery: getInspectQuery
  }), /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
    updatedAt: updatedAt
  }), controls === null || controls === void 0 ? void 0 : controls.right);
};
const getDefaultVisibility = ({
  alertsCount,
  updatedAt,
  columnIds,
  onToggleColumn,
  onResetColumns,
  browserFields,
  controls,
  fieldBrowserOptions,
  getInspectQuery,
  showInspectButton
}) => {
  const hasBrowserFields = Object.keys(browserFields).length > 0;
  const additionalControls = {
    right: rightControl({
      controls,
      updatedAt,
      getInspectQuery,
      showInspectButton
    }),
    left: {
      append: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alerts_count.AlertsCount, {
        count: alertsCount
      }), hasBrowserFields && /*#__PURE__*/_react.default.createElement(_field_browser.FieldBrowser, {
        columnIds: columnIds,
        browserFields: browserFields,
        onResetColumns: onResetColumns,
        onToggleColumn: onToggleColumn,
        options: fieldBrowserOptions
      }))
    }
  };
  return {
    additionalControls,
    showColumnSelector: {
      allowHide: false
    },
    showSortSelector: true
  };
};
const getToolbarVisibility = ({
  bulkActions,
  alertsCount,
  rowSelection,
  alerts,
  isLoading,
  updatedAt,
  columnIds,
  onToggleColumn,
  onResetColumns,
  browserFields,
  setIsBulkActionsLoading,
  clearSelection,
  controls,
  refresh,
  fieldBrowserOptions,
  getInspectQuery,
  showInspectButton,
  toolbarVisiblityProp
}) => {
  const selectedRowsCount = rowSelection.size;
  const defaultVisibility = getDefaultVisibility({
    alertsCount,
    updatedAt,
    columnIds,
    onToggleColumn,
    onResetColumns,
    browserFields,
    controls,
    fieldBrowserOptions,
    getInspectQuery,
    showInspectButton
  });
  const isBulkActionsActive = selectedRowsCount === 0 || selectedRowsCount === undefined || bulkActions.length === 0;
  if (isBulkActionsActive) return {
    ...defaultVisibility,
    ...(toolbarVisiblityProp !== null && toolbarVisiblityProp !== void 0 ? toolbarVisiblityProp : {})
  };
  const options = {
    showColumnSelector: false,
    showSortSelector: false,
    additionalControls: {
      right: rightControl({
        controls,
        updatedAt,
        getInspectQuery,
        showInspectButton
      }),
      left: {
        append: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alerts_count.AlertsCount, {
          count: alertsCount
        }), /*#__PURE__*/_react.default.createElement(_react.Suspense, {
          fallback: null
        }, /*#__PURE__*/_react.default.createElement(BulkActionsToolbar, {
          totalItems: alertsCount,
          items: bulkActions,
          alerts: alerts,
          setIsBulkActionsLoading: setIsBulkActionsLoading,
          clearSelection: clearSelection,
          refresh: refresh
        })))
      }
    },
    ...(toolbarVisiblityProp !== null && toolbarVisiblityProp !== void 0 ? toolbarVisiblityProp : {})
  };
  return options;
};
exports.getToolbarVisibility = getToolbarVisibility;