"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toggleColumn = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const remove = ({
  columns,
  index
}) => {
  return [...columns.slice(0, index), ...columns.slice(index + 1)];
};
const insert = ({
  column,
  columns,
  defaultColumns
}) => {
  const defaultIndex = defaultColumns.findIndex(defaultColumn => defaultColumn.id === column.id);
  const isInDefaultConfig = defaultIndex >= 0;

  // if the column isn't shown but it's part of the default config
  // insert into the same position as in the default config
  if (isInDefaultConfig) {
    return [...columns.slice(0, defaultIndex), column, ...columns.slice(defaultIndex)];
  }
  if (columns.length === 0) {
    return [column];
  }

  // if the column isn't shown and it's not part of the default config
  // push it into the second position. Behaviour copied by t_grid, security
  // does this to insert right after the timestamp column
  return [columns[0], column, ...columns.slice(1)];
};
const formatSystemColumn = column => {
  const newColumn = {
    ...column
  };
  if (newColumn.id === _ruleDataUtils.ALERT_CASE_IDS) {
    newColumn.isSortable = false;

    /**
     * If a solution wants to default the case column and set their own
     * display text we should not modified it. For that reason,
     * we check if the displayAsText is set.
     */
    if (!newColumn.displayAsText) {
      newColumn.displayAsText = i18n.CASES;
    }
  }
  return newColumn;
};

/**
 * @param param.column column to be removed/inserted
 * @param param.columns current array of columns in the grid
 * @param param.defaultColumns Initial columns set up in the configuration before being modified by the user
 * @returns the new list of columns
 */
const toggleColumn = ({
  column,
  columns,
  defaultColumns
}) => {
  const currentIndex = columns.findIndex(currentColumn => currentColumn.id === column.id);
  const isVisible = currentIndex >= 0;

  /**
   * For the Cases column we want to change the
   * label of the column from kibana.alert.case_ids to Cases.
   */
  const formattedColumn = formatSystemColumn(column);
  if (isVisible) {
    return remove({
      columns,
      index: currentIndex
    });
  }
  return insert({
    defaultColumns,
    column: formattedColumn,
    columns
  });
};
exports.toggleColumn = toggleColumn;