"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkGetCases = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _common = require("../../../../common");
var _constants = require("../../../hooks/constants");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.cases.api.bulkGet', {
  defaultMessage: 'Error fetching cases data'
});
const caseFields = ['title', 'description', 'status', 'totalComment', 'created_at', 'created_by'];
const transformCases = data => {
  const casesMap = new Map();
  for (const theCase of (_data$cases = data === null || data === void 0 ? void 0 : data.cases) !== null && _data$cases !== void 0 ? _data$cases : []) {
    var _data$cases;
    casesMap.set(theCase.id, {
      ...theCase
    });
  }
  return casesMap;
};
const useBulkGetCases = (caseIds, fetchCases) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _common.useKibana)().services;
  return (0, _reactQuery.useQuery)(_constants.triggersActionsUiQueriesKeys.casesBulkGet(caseIds), () => {
    const abortCtrlRef = new AbortController();
    return (0, _api.bulkGetCases)(http, {
      ids: caseIds,
      fields: caseFields
    }, abortCtrlRef.signal);
  }, {
    enabled: caseIds.length > 0 && fetchCases,
    select: transformCases,
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: ERROR_TITLE
        });
      }
    }
  });
};
exports.useBulkGetCases = useBulkGetCases;