"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActions = useBulkActions;
exports.useBulkAddToCaseActions = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _types = require("../../../../types");
var _context = require("../bulk_actions/context");
var _get_leading_control_column = require("../bulk_actions/get_leading_control_column");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterAlertsAlreadyAttachedToCase = (alerts, caseId) => alerts.filter(alert => !alert.data.some(field => {
  var _field$value;
  return field.field === _ruleDataUtils.ALERT_CASE_IDS && ((_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.some(id => id === caseId));
}));
const getCaseAttachments = ({
  alerts,
  caseId,
  groupAlertsByRule
}) => {
  var _groupAlertsByRule;
  const filteredAlerts = filterAlertsAlreadyAttachedToCase(alerts !== null && alerts !== void 0 ? alerts : [], caseId);
  return (_groupAlertsByRule = groupAlertsByRule === null || groupAlertsByRule === void 0 ? void 0 : groupAlertsByRule(filteredAlerts)) !== null && _groupAlertsByRule !== void 0 ? _groupAlertsByRule : [];
};
const useBulkAddToCaseActions = ({
  casesConfig,
  refresh,
  clearSelection
}) => {
  var _casesConfig$owner;
  const {
    cases: casesService
  } = (0, _public.useKibana)().services;
  const userCasesPermissions = casesService === null || casesService === void 0 ? void 0 : casesService.helpers.canUseCases((_casesConfig$owner = casesConfig === null || casesConfig === void 0 ? void 0 : casesConfig.owner) !== null && _casesConfig$owner !== void 0 ? _casesConfig$owner : []);
  const CasesContext = casesService === null || casesService === void 0 ? void 0 : casesService.ui.getCasesContext();
  const isCasesContextAvailable = Boolean(casesService && CasesContext);
  const onSuccess = (0, _react.useCallback)(() => {
    refresh();
    clearSelection();
  }, [clearSelection, refresh]);
  const createCaseFlyout = casesService === null || casesService === void 0 ? void 0 : casesService.hooks.useCasesAddToNewCaseFlyout({
    onSuccess
  });
  const selectCaseModal = casesService === null || casesService === void 0 ? void 0 : casesService.hooks.useCasesAddToExistingCaseModal({
    onSuccess,
    noAttachmentsToaster: {
      title: _translations.NO_ALERTS_ADDED_TO_CASE,
      content: _translations.ALERTS_ALREADY_ATTACHED_TO_CASE
    }
  });
  return (0, _react.useMemo)(() => {
    return isCasesContextAvailable && createCaseFlyout && selectCaseModal && userCasesPermissions !== null && userCasesPermissions !== void 0 && userCasesPermissions.create && userCasesPermissions !== null && userCasesPermissions !== void 0 && userCasesPermissions.read ? [{
      label: _translations.ADD_TO_NEW_CASE,
      key: 'attach-new-case',
      'data-test-subj': 'attach-new-case',
      disableOnQuery: true,
      disabledLabel: _translations.ADD_TO_NEW_CASE,
      onClick: alerts => {
        var _casesService$helpers;
        const caseAttachments = alerts ? (_casesService$helpers = casesService === null || casesService === void 0 ? void 0 : casesService.helpers.groupAlertsByRule(alerts)) !== null && _casesService$helpers !== void 0 ? _casesService$helpers : [] : [];
        createCaseFlyout.open({
          attachments: caseAttachments
        });
      }
    }, {
      label: _translations.ADD_TO_EXISTING_CASE,
      key: 'attach-existing-case',
      disableOnQuery: true,
      disabledLabel: _translations.ADD_TO_EXISTING_CASE,
      'data-test-subj': 'attach-existing-case',
      onClick: alerts => {
        selectCaseModal.open({
          getAttachments: ({
            theCase
          }) => {
            return getCaseAttachments({
              alerts,
              caseId: theCase.id,
              groupAlertsByRule: casesService === null || casesService === void 0 ? void 0 : casesService.helpers.groupAlertsByRule
            });
          }
        });
      }
    }] : [];
  }, [casesService === null || casesService === void 0 ? void 0 : casesService.helpers, createCaseFlyout, isCasesContextAvailable, selectCaseModal, userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.create, userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.read]);
};
exports.useBulkAddToCaseActions = useBulkAddToCaseActions;
function useBulkActions({
  alerts,
  casesConfig,
  query,
  refresh,
  useBulkActionsConfig = () => []
}) {
  const [bulkActionsState, updateBulkActionsState] = (0, _react.useContext)(_context.BulkActionsContext);
  const configBulkActions = useBulkActionsConfig(query);
  const clearSelection = () => {
    updateBulkActionsState({
      action: _types.BulkActionsVerbs.clear
    });
  };
  const caseBulkActions = useBulkAddToCaseActions({
    casesConfig,
    refresh,
    clearSelection
  });
  const bulkActions = [...configBulkActions, ...caseBulkActions];
  const isBulkActionsColumnActive = bulkActions.length !== 0;
  (0, _react.useEffect)(() => {
    updateBulkActionsState({
      action: _types.BulkActionsVerbs.rowCountUpdate,
      rowCount: alerts.length
    });
  }, [alerts, updateBulkActionsState]);
  const setIsBulkActionsLoading = (isLoading = true) => {
    updateBulkActionsState({
      action: _types.BulkActionsVerbs.updateAllLoadingState,
      isLoading
    });
  };
  return {
    isBulkActionsColumnActive,
    getBulkActionsLeadingControlColumn: _get_leading_control_column.getLeadingControlColumn,
    bulkActionsState,
    bulkActions,
    setIsBulkActionsLoading,
    clearSelection
  };
}