"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActionsColumn = void 0;
var _react = require("react");
var _types = require("../../../../types");
var _context = require("../bulk_actions/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ACTIONS_COLUMNS_WIDTH = 75;
const useActionsColumn = ({
  options
}) => {
  const [, updateBulkActionsState] = (0, _react.useContext)(_context.BulkActionsContext);
  const useUserActionsColumn = options ? options : () => ({
    renderCustomActionsRow: undefined,
    width: undefined
  });
  const {
    renderCustomActionsRow,
    width: actionsColumnWidth = DEFAULT_ACTIONS_COLUMNS_WIDTH
  } = useUserActionsColumn();

  // we save the rowIndex when creating the function to be used by the clients
  // so they don't have to manage it
  const getSetIsActionLoadingCallback = rowIndex => (isLoading = true) => {
    updateBulkActionsState({
      action: _types.BulkActionsVerbs.updateRowLoadingState,
      rowIndex,
      isLoading
    });
  };
  return {
    renderCustomActionsRow,
    actionsColumnWidth,
    getSetIsActionLoadingCallback
  };
};
exports.useActionsColumn = useActionsColumn;