"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _casesComponents = require("@kbn/cases-components");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_case_view_navigation = require("./use_case_view_navigation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatCase = theCase => {
  var _theCase$created_by$u, _theCase$created_by$f;
  return {
    title: theCase.title,
    description: theCase.description,
    createdAt: theCase.created_at,
    createdBy: {
      username: (_theCase$created_by$u = theCase.created_by.username) !== null && _theCase$created_by$u !== void 0 ? _theCase$created_by$u : undefined,
      fullName: (_theCase$created_by$f = theCase.created_by.full_name) !== null && _theCase$created_by$f !== void 0 ? _theCase$created_by$f : undefined
    },
    status: theCase.status,
    totalComments: theCase.totalComment
  };
};
const CasesCellComponent = props => {
  var _alert$ALERT_CASE_IDS;
  const {
    isLoading,
    alert,
    cases
  } = props;
  const {
    navigateToCaseView
  } = (0, _use_case_view_navigation.useCaseViewNavigation)();
  const caseIds = (_alert$ALERT_CASE_IDS = alert[_ruleDataUtils.ALERT_CASE_IDS]) !== null && _alert$ALERT_CASE_IDS !== void 0 ? _alert$ALERT_CASE_IDS : [];
  const validCases = caseIds.map(id => cases.get(id)).filter(theCase => theCase != null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    isLoading: isLoading,
    size: "s",
    "data-test-subj": "cases-cell-loading"
  }, validCases.length !== 0 ? validCases.map((theCase, index) => [index > 0 && index < validCases.length && ', ', /*#__PURE__*/_react.default.createElement(_casesComponents.Tooltip, {
    loading: false,
    content: formatCase(theCase),
    key: theCase.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => navigateToCaseView({
      caseId: theCase.id
    }),
    "data-test-subj": "cases-cell-link"
  }, theCase.title))]) : '--');
};
CasesCellComponent.displayName = 'CasesCell';
const CasesCell = /*#__PURE__*/(0, _react.memo)(CasesCellComponent);
exports.CasesCell = CasesCell;