"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const AlertsFlyoutHeader = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./alerts_flyout_header'))));
const PAGINATION_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.alertsTable.alertsFlyout.paginationLabel', {
  defaultMessage: 'Alert navigation'
});
function usePrevious(alert) {
  const ref = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (alert) {
      ref.current = alert;
    }
  });
  return ref.current;
}
const AlertsFlyout = ({
  alert,
  alertsTableConfiguration,
  flyoutIndex,
  flyoutSize = 'm',
  alertsCount,
  isLoading,
  onClose,
  onPaginate,
  id
}) => {
  var _alertsTableConfigura, _alertsTableConfigura2;
  const {
    header: Header,
    body: Body,
    footer: Footer
  } = (_alertsTableConfigura = alertsTableConfiguration === null || alertsTableConfiguration === void 0 ? void 0 : (_alertsTableConfigura2 = alertsTableConfiguration.useInternalFlyout) === null || _alertsTableConfigura2 === void 0 ? void 0 : _alertsTableConfigura2.call(alertsTableConfiguration)) !== null && _alertsTableConfigura !== void 0 ? _alertsTableConfigura : {
    header: AlertsFlyoutHeader,
    body: null,
    footer: null
  };
  const prevAlert = usePrevious(alert);
  const passedProps = (0, _react.useMemo)(() => ({
    alert: alert === undefined && prevAlert != null ? prevAlert : alert,
    id,
    isLoading
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [alert, id, isLoading]);
  const FlyoutBody = (0, _react.useCallback)(() => Body ? /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(Body, passedProps)) : null, [Body, passedProps]);
  const FlyoutFooter = (0, _react.useCallback)(() => Footer ? /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(Footer, passedProps)) : null, [Footer, passedProps]);
  const FlyoutHeader = (0, _react.useCallback)(() => Header ? /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(Header, passedProps)) : null, [Header, passedProps]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: flyoutSize,
    "data-test-subj": "alertsFlyout",
    ownFocus: false
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    "data-test-subj": "alertsFlyoutLoading"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(FlyoutHeader, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": PAGINATION_LABEL,
    pageCount: alertsCount,
    activePage: flyoutIndex,
    onPageClick: onPaginate,
    compressed: true,
    "data-test-subj": "alertsFlyoutPagination"
  })))), /*#__PURE__*/_react.default.createElement(FlyoutBody, null), /*#__PURE__*/_react.default.createElement(FlyoutFooter, null));
};
exports.AlertsFlyout = AlertsFlyout;