"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSummaryWidgetCompact = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _eui_charts_theme = require("@elastic/eui/dist/eui_charts_theme");
var _alert_counts = require("./alert_counts");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSummaryWidgetCompact = ({
  activeAlertCount,
  activeAlerts,
  chartProps: {
    theme,
    baseTheme
  },
  recoveredAlertCount,
  timeRangeTitle,
  onClick
}) => {
  const chartTheme = [theme, _eui_charts_theme.EUI_SPARKLINE_THEME_PARTIAL, {
    chartMargins: {
      left: 10,
      right: 10,
      top: 10,
      bottom: 10
    }
  }];
  const handleClick = (event, status) => {
    event.preventDefault();
    event.stopPropagation();
    onClick(status);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    element: "div",
    "data-test-subj": "alertSummaryWidgetCompact",
    hasShadow: false,
    hasBorder: true,
    onClick: handleClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, !!timeRangeTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _constants.WIDGET_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": "timeRangeTitle"
  }, timeRangeTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alert_counts.AlertCounts, {
    activeAlertCount: activeAlertCount,
    recoveredAlertCount: recoveredAlertCount,
    onActiveClick: handleClick
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 50
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: chartTheme,
    baseTheme: baseTheme,
    tooltip: {
      type: 'none'
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    hide: true,
    id: "activeAlertsAxis",
    position: _charts.Position.Left,
    showGridLines: false
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: 'activeAlertsChart',
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['doc_count'],
    data: activeAlerts,
    lineSeriesStyle: {
      line: {
        strokeWidth: 2,
        stroke: _constants.ALL_ALERT_COLOR
      }
    },
    curve: _charts.CurveType.CURVE_MONOTONE_X
  })))))));
};
exports.AlertSummaryWidgetCompact = AlertSummaryWidgetCompact;