"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActiveAlertCounts = void 0;
var _react = _interopRequireDefault(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActiveAlertCounts = ({
  activeAlertCount
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: !!activeAlertCount ? euiTheme.colors.dangerText : euiTheme.colors.successText
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": _constants.ACTIVE_ALERT_COUNT_DATA_TEST_SUBJ
  }, (0, _numeral.default)(activeAlertCount).format(_constants.ALERT_COUNT_FORMAT), !!activeAlertCount && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    ascent: 10
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _constants.ACTIVE_NOW_LABEL));
};
exports.ActiveAlertCounts = ActiveAlertCounts;