"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
var _common2 = require("@kbn/actions-plugin/common");
var _action_connector_api = require("../../../lib/action_connector_api");
var _capabilities = require("../../../lib/capabilities");
var _delete_modal_confirmation = require("../../../components/delete_modal_confirmation");
var _check_action_type_enabled = require("../../../lib/check_action_type_enabled");
require("./actions_connectors_list.scss");
var _types = require("../../../../types");
var _empty_connectors_prompt = require("../../../components/prompts/empty_connectors_prompt");
var _kibana = require("../../../../common/lib/kibana");
var _center_justified_spinner = require("../../../components/center_justified_spinner");
var _connectors_selection = require("../../../../common/connectors_selection");
var _create_connector_flyout = require("../../action_connector_form/create_connector_flyout");
var _edit_connector_flyout = require("../../action_connector_form/edit_connector_flyout");
var _breadcrumb = require("../../../lib/breadcrumb");
var _doc_title = require("../../../lib/doc_title");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorIconTipWithSpacing = (0, _common.withTheme)(({
  theme
}) => {
  return /*#__PURE__*/_react2.default.createElement(_react.ClassNames, null, ({
    css
  }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    anchorClassName: css({
      /**
       * Adds some spacing to the left of the warning icon for deprecated connectors
       */
      marginLeft: theme.eui.euiSizeS,
      marginBottom: '0 !important'
    }),
    "aria-label": "Warning",
    size: "m",
    type: "warning",
    color: "warning",
    content: _connectors_selection.connectorDeprecatedMessage,
    position: "right"
  }));
});
const ActionsConnectorsList = () => {
  const {
    http,
    notifications: {
      toasts
    },
    application: {
      capabilities
    },
    actionTypeRegistry,
    setBreadcrumbs,
    chrome,
    docLinks
  } = (0, _kibana.useKibana)().services;
  const canDelete = (0, _capabilities.hasDeleteActionsCapability)(capabilities);
  const canExecute = (0, _capabilities.hasExecuteActionsCapability)(capabilities);
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const [actionTypesIndex, setActionTypesIndex] = (0, _react2.useState)(undefined);
  const [actions, setActions] = (0, _react2.useState)([]);
  const [pageIndex, setPageIndex] = (0, _react2.useState)(0);
  const [selectedItems, setSelectedItems] = (0, _react2.useState)([]);
  const [isLoadingActionTypes, setIsLoadingActionTypes] = (0, _react2.useState)(false);
  const [isLoadingActions, setIsLoadingActions] = (0, _react2.useState)(false);
  const [addFlyoutVisible, setAddFlyoutVisibility] = (0, _react2.useState)(false);
  const [editConnectorProps, setEditConnectorProps] = (0, _react2.useState)({});
  const [connectorsToDelete, setConnectorsToDelete] = (0, _react2.useState)([]);
  (0, _react2.useEffect)(() => {
    loadActions();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const [showWarningText, setShowWarningText] = (0, _react2.useState)(false);

  // Set breadcrumb and page title
  (0, _react2.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)('connectors')]);
    chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)('connectors'));
  }, [chrome, setBreadcrumbs]);
  (0, _react2.useEffect)(() => {
    (async () => {
      try {
        setIsLoadingActionTypes(true);
        const actionTypes = await (0, _action_connector_api.loadActionTypes)({
          http
        });
        const index = {};
        for (const actionTypeItem of actionTypes) {
          index[actionTypeItem.id] = actionTypeItem;
        }
        setActionTypesIndex(index);
      } catch (e) {
        toasts.addDanger({
          title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.unableToLoadConnectorTypesMessage', {
            defaultMessage: 'Unable to load connector types'
          })
        });
      } finally {
        setIsLoadingActionTypes(false);
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const actionConnectorTableItems = actionTypesIndex ? actions.map(action => {
    return {
      ...action,
      actionType: actionTypesIndex[action.actionTypeId] ? actionTypesIndex[action.actionTypeId].name : action.actionTypeId,
      compatibility: actionTypesIndex[action.actionTypeId] ? (0, _common2.getConnectorCompatibility)(actionTypesIndex[action.actionTypeId].supportedFeatureIds) : []
    };
  }) : [];
  const actionTypesList = actionTypesIndex ? Object.values(actionTypesIndex).map(actionType => ({
    value: actionType.id,
    name: `${actionType.name} (${getActionsCountByActionType(actions, actionType.id)})`
  })).sort((a, b) => a.name.localeCompare(b.name)) : [];
  function setDeleteConnectorWarning(connectors) {
    const show = connectors.some(c => {
      const action = actions.find(a => a.id === c);
      return (action && action.referencedByCount ? action.referencedByCount : 0) > 0;
    });
    setShowWarningText(show);
  }
  function onDelete(items) {
    const itemIds = items.map(item => item.id);
    setConnectorsToDelete(itemIds);
    setDeleteConnectorWarning(itemIds);
  }
  async function loadActions() {
    setIsLoadingActions(true);
    try {
      const actionsResponse = await (0, _action_connector_api.loadAllActions)({
        http
      });
      setActions(actionsResponse);
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.unableToLoadActionsMessage', {
          defaultMessage: 'Unable to load connectors'
        })
      });
    } finally {
      setIsLoadingActions(false);
    }
  }
  async function editItem(actionConnector, tab, isFix) {
    setEditConnectorProps({
      initialConnector: actionConnector,
      tab,
      isFix: isFix !== null && isFix !== void 0 ? isFix : false
    });
  }
  const actionsTableColumns = [{
    field: 'name',
    'data-test-subj': 'connectorsTableCell-name',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.nameTitle', {
      defaultMessage: 'Name'
    }),
    sortable: false,
    truncateText: true,
    render: (value, item) => {
      var _actionTypesIndex$ite;
      const checkEnabledResult = (0, _check_action_type_enabled.checkActionTypeEnabled)(actionTypesIndex && actionTypesIndex[item.actionTypeId]);

      /**
       * TODO: Remove when connectors can provide their own UX message.
       * Issue: https://github.com/elastic/kibana/issues/114507
       */
      const showDeprecatedTooltip = item.isDeprecated;
      const name = getConnectorName(value, item);
      const link = /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
        "data-test-subj": `edit${item.id}`,
        title: name,
        onClick: () => editItem(item, _types.EditConnectorTabs.Configuration),
        key: item.id,
        disabled: actionTypesIndex ? !((_actionTypesIndex$ite = actionTypesIndex[item.actionTypeId]) !== null && _actionTypesIndex$ite !== void 0 && _actionTypesIndex$ite.enabled) : true
      }, name), item.isMissingSecrets ? /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
        iconProps: {
          'data-test-subj': `missingSecrets_${item.id}`
        },
        type: "warning",
        color: "warning",
        content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.missingSecretsDescription', {
          defaultMessage: 'Sensitive information was not imported'
        }),
        position: "right"
      }) : null, showDeprecatedTooltip && /*#__PURE__*/_react2.default.createElement(ConnectorIconTipWithSpacing, null));
      return checkEnabledResult.isEnabled ? link : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, link, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
        type: "questionInCircle",
        content: checkEnabledResult.message,
        position: "right"
      }));
    }
  }, {
    field: 'actionType',
    'data-test-subj': 'connectorsTableCell-actionType',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actionTypeTitle', {
      defaultMessage: 'Type'
    }),
    sortable: false,
    truncateText: true
  }, {
    field: 'compatibility',
    'data-test-subj': 'connectorsTableCell-compatibility',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.compatibility', {
      defaultMessage: 'Compatibility'
    }),
    sortable: false,
    truncateText: true,
    render: compatibility => {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        wrap: true,
        responsive: false,
        gutterSize: "xs",
        "data-test-subj": "compatibility-content"
      }, compatibility.map(compatibilityItem => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: compatibilityItem
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
        "data-test-subj": "connectorsTableCell-compatibility-badge",
        color: "default"
      }, compatibilityItem))));
    }
  }, {
    name: '',
    render: item => {
      var _actionTypesIndex$ite2;
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexEnd",
        alignItems: "flexEnd"
      }, /*#__PURE__*/_react2.default.createElement(DeleteOperation, {
        canDelete: canDelete,
        item: item,
        onDelete: () => onDelete([item])
      }), item.isMissingSecrets ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, actionTypesIndex && (_actionTypesIndex$ite2 = actionTypesIndex[item.actionTypeId]) !== null && _actionTypesIndex$ite2 !== void 0 && _actionTypesIndex$ite2.enabled ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        style: {
          marginLeft: 4
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.fixActionDescription', {
          defaultMessage: 'Fix connector configuration'
        })
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        "data-test-subj": "fixConnectorButton",
        onClick: () => editItem(item, _types.EditConnectorTabs.Configuration, true)
      }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.fixButtonLabel', {
        defaultMessage: 'Fix'
      })))) : null) : /*#__PURE__*/_react2.default.createElement(RunOperation, {
        canExecute: canExecute && actionTypesIndex && actionTypesIndex[item.actionTypeId],
        item: item,
        onRun: () => editItem(item, _types.EditConnectorTabs.Test)
      }));
    }
  }];
  const table = /*#__PURE__*/_react2.default.createElement(_eui.EuiInMemoryTable, {
    loading: isLoadingActions || isLoadingActionTypes,
    items: actionConnectorTableItems,
    sorting: true,
    itemId: "id",
    columns: actionsTableColumns,
    rowProps: item => {
      var _actionTypesIndex$ite3;
      return {
        className: !actionTypesIndex || !((_actionTypesIndex$ite3 = actionTypesIndex[item.actionTypeId]) !== null && _actionTypesIndex$ite3 !== void 0 && _actionTypesIndex$ite3.enabled) ? 'actConnectorsList__tableRowDisabled' : '',
        'data-test-subj': 'connectors-row'
      };
    },
    cellProps: item => {
      var _actionTypesIndex$ite4;
      return {
        'data-test-subj': 'cell',
        className: !actionTypesIndex || !((_actionTypesIndex$ite4 = actionTypesIndex[item.actionTypeId]) !== null && _actionTypesIndex$ite4 !== void 0 && _actionTypesIndex$ite4.enabled) ? 'actConnectorsList__tableCellDisabled' : ''
      };
    },
    "data-test-subj": "actionsTable",
    pagination: {
      initialPageIndex: 0,
      pageIndex
    },
    onTableChange: ({
      page
    }) => {
      if (page) {
        setPageIndex(page.index);
      }
    },
    selection: canDelete ? {
      onSelectionChange(updatedSelectedItemsList) {
        setSelectedItems(updatedSelectedItemsList);
      },
      selectable: ({
        isPreconfigured
      }) => !isPreconfigured
    } : undefined,
    search: {
      filters: [{
        type: 'field_value_selection',
        field: 'actionTypeId',
        name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.filters.actionTypeIdName', {
          defaultMessage: 'Type'
        }),
        multiSelect: 'or',
        options: actionTypesList
      }],
      toolsLeft: (selectedItems.length === 0 || !canDelete ? [] : [/*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
        key: "delete",
        iconType: "trash",
        color: "danger",
        "data-test-subj": "bulkDelete",
        onClick: () => onDelete(selectedItems),
        title: canDelete ? undefined : _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.buttons.deleteDisabledTitle', {
          defaultMessage: 'Unable to delete connectors'
        })
      }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.actionsConnectorsList.buttons.deleteLabel",
        defaultMessage: "Delete {count}",
        values: {
          count: selectedItems.length
        }
      }))]).concat(canSave ? [/*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
        "data-test-subj": "createActionButton",
        key: "create-action",
        fill: true,
        onClick: () => setAddFlyoutVisibility(true)
      }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.actionsConnectorsList.addActionButtonLabel",
        defaultMessage: "Create connector"
      }))] : [])
    }
  });
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: "none",
    "data-test-subj": "actionsList",
    alignment: actionConnectorTableItems.length === 0 ? 'center' : 'top'
  }, /*#__PURE__*/_react2.default.createElement(_delete_modal_confirmation.DeleteModalConfirmation, {
    "data-test-subj": "deleteConnectorsConfirmation",
    onDeleted: deleted => {
      if (selectedItems.length === 0 || selectedItems.length === deleted.length) {
        const updatedActions = actions.filter(action => action.id && !connectorsToDelete.includes(action.id));
        setActions(updatedActions);
        setSelectedItems([]);
      }
      setConnectorsToDelete([]);
    },
    onErrors: async () => {
      // Refresh the actions from the server, some actions may have beend deleted
      await loadActions();
      setConnectorsToDelete([]);
    },
    onCancel: async () => {
      setConnectorsToDelete([]);
    },
    apiDeleteCall: _action_connector_api.deleteActions,
    idsToDelete: connectorsToDelete,
    singleTitle: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.singleTitle', {
      defaultMessage: 'connector'
    }),
    multipleTitle: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.multipleTitle', {
      defaultMessage: 'connectors'
    }),
    showWarningText: showWarningText,
    warningText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.warningText', {
      defaultMessage: '{connectors, plural, one {This connector is} other {Some connectors are}} currently in use.',
      values: {
        connectors: connectorsToDelete.length
      }
    }),
    setIsLoadingState: isLoading => setIsLoadingActionTypes(isLoading)
  }), (isLoadingActions || isLoadingActionTypes) && /*#__PURE__*/_react2.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null), actionConnectorTableItems.length !== 0 && table, actionConnectorTableItems.length === 0 && canSave && !isLoadingActions && !isLoadingActionTypes && /*#__PURE__*/_react2.default.createElement(_empty_connectors_prompt.EmptyConnectorsPrompt, {
    onCTAClicked: () => setAddFlyoutVisibility(true),
    docLinks: docLinks
  }), actionConnectorTableItems.length === 0 && !canSave && /*#__PURE__*/_react2.default.createElement(NoPermissionPrompt, null), addFlyoutVisible ? /*#__PURE__*/_react2.default.createElement(_create_connector_flyout.CreateConnectorFlyout, {
    onClose: () => {
      setAddFlyoutVisibility(false);
    },
    onTestConnector: connector => editItem(connector, _types.EditConnectorTabs.Test),
    onConnectorCreated: loadActions,
    actionTypeRegistry: actionTypeRegistry
  }) : null, editConnectorProps.initialConnector ? /*#__PURE__*/_react2.default.createElement(_edit_connector_flyout.EditConnectorFlyout, {
    key: `${editConnectorProps.initialConnector.id}${editConnectorProps.tab ? `:${editConnectorProps.tab}` : ``}`,
    connector: editConnectorProps.initialConnector,
    tab: editConnectorProps.tab,
    onClose: () => {
      setEditConnectorProps((0, _lodash.omit)(editConnectorProps, 'initialConnector'));
    },
    onConnectorUpdated: connector => {
      setEditConnectorProps({
        ...editConnectorProps,
        initialConnector: connector
      });
      loadActions();
    },
    actionTypeRegistry: actionTypeRegistry
  }) : null));
};

// eslint-disable-next-line import/no-default-export
exports.default = ActionsConnectorsList;
function getActionsCountByActionType(actions, actionTypeId) {
  return actions.filter(action => action.actionTypeId === actionTypeId).length;
}
function getConnectorName(name, connector) {
  return connector.isDeprecated ? `${name} ${_connectors_selection.deprecatedMessage}` : name;
}
const DeleteOperation = ({
  item,
  canDelete,
  onDelete
}) => {
  if (item.isPreconfigured) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBetaBadge, {
      "data-test-subj": "preConfiguredTitleMessage",
      label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.preconfiguredTitleMessage', {
        defaultMessage: 'Preconfigured'
      }),
      tooltipContent: "This connector can't be deleted."
    }));
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: canDelete ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.deleteActionDescription', {
      defaultMessage: 'Delete this connector'
    }) : _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.deleteActionDisabledDescription', {
      defaultMessage: 'Unable to delete connectors'
    })
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    isDisabled: !canDelete,
    "data-test-subj": "deleteConnector",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.deleteActionName', {
      defaultMessage: 'Delete'
    }),
    onClick: onDelete,
    iconType: 'trash'
  })));
};
const RunOperation = ({
  item,
  canExecute,
  onRun
}) => {
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: canExecute ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.runConnectorDescription', {
      defaultMessage: 'Run this connector'
    }) : _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.runConnectorDisabledDescription', {
      defaultMessage: 'Unable to run connectors'
    })
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    isDisabled: !canExecute,
    "data-test-subj": "runConnector",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.runConnectorName', {
      defaultMessage: 'Run'
    }),
    onClick: onRun,
    iconType: 'play'
  })));
};
const NoPermissionPrompt = () => /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "securityApp",
  title: /*#__PURE__*/_react2.default.createElement("h1", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionsConnectorsList.noPermissionToCreateTitle",
    defaultMessage: "No permissions to create connectors"
  })),
  body: /*#__PURE__*/_react2.default.createElement("p", {
    "data-test-subj": "permissionDeniedMessage"
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionsConnectorsList.noPermissionToCreateDescription",
    defaultMessage: "Contact your system administrator."
  }))
});
module.exports = exports.default;