"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorFormFieldsGlobal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _i18n = require("@kbn/i18n");
var _hidden_field = require("../../components/hidden_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const nameConfig = {
  label: 'Connector name',
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorForm.error.requiredNameText', {
      defaultMessage: 'Name is required.'
    }))
  }]
};
const ConnectorFormFieldsGlobalComponent = ({
  canSave
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hidden_field.HiddenField, {
    path: 'id'
  }), /*#__PURE__*/_react.default.createElement(_hidden_field.HiddenField, {
    path: 'actionTypeId'
  }), /*#__PURE__*/_react.default.createElement(_hidden_field.HiddenField, {
    path: 'isDeprecated'
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "name",
    config: nameConfig,
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly: !canSave,
        'data-test-subj': 'nameInput',
        fullWidth: true
      }
    }
  }));
};
const ConnectorFormFieldsGlobal = /*#__PURE__*/(0, _react.memo)(ConnectorFormFieldsGlobalComponent);
exports.ConnectorFormFieldsGlobal = ConnectorFormFieldsGlobal;