"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
require("./connector_add_modal.scss");
var _beta_badge_props = require("./beta_badge_props");
var _capabilities = require("../../lib/capabilities");
var _kibana = require("../../../common/lib/kibana");
var _use_create_connector = require("../../hooks/use_create_connector");
var _connector_form = require("./connector_form");
var _action_connector_api = require("../../lib/action_connector_api");
var _components = require("../../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorAddModal = ({
  actionType: tempActionType,
  onClose,
  postSaveEventHandler,
  actionTypeRegistry
}) => {
  var _actionType$id, _actionTypeModel$subt;
  const {
    application: {
      capabilities
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [actionType, setActionType] = (0, _react.useState)(tempActionType);
  const [loadingActionTypes, setLoadingActionTypes] = (0, _react.useState)(false);
  const [allActionTypes, setAllActionTypes] = (0, _react.useState)(undefined);
  const {
    isLoading: isSavingConnector,
    createConnector
  } = (0, _use_create_connector.useCreateConnector)();
  const isMounted = (0, _react.useRef)(false);
  const [initialConnector, setInitialConnector] = (0, _react.useState)({
    actionTypeId: (_actionType$id = actionType === null || actionType === void 0 ? void 0 : actionType.id) !== null && _actionType$id !== void 0 ? _actionType$id : '',
    isDeprecated: false,
    config: {},
    secrets: {},
    isMissingSecrets: false
  });
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const actionTypeModel = actionTypeRegistry.get(actionType.id);
  const groupActionTypeModel = actionTypeModel && actionTypeModel.subtype ? ((_actionTypeModel$subt = actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.subtype) !== null && _actionTypeModel$subt !== void 0 ? _actionTypeModel$subt : []).map(subtypeAction => ({
    ...actionTypeRegistry.get(subtypeAction.id),
    name: subtypeAction.name
  })) : [];
  const groupActionButtons = groupActionTypeModel.map(gAction => ({
    id: gAction.id,
    label: gAction.name,
    'data-test-subj': `${gAction.id}Button`
  }));
  const resetConnectorForm = (0, _react.useRef)();
  const setResetForm = reset => {
    resetConnectorForm.current = reset;
  };
  const onChangeGroupAction = id => {
    if (allActionTypes && allActionTypes[id]) {
      setActionType(allActionTypes[id]);
      setInitialConnector({
        actionTypeId: id,
        isDeprecated: false,
        config: {},
        secrets: {},
        isMissingSecrets: false
      });
      if (resetConnectorForm.current) {
        resetConnectorForm.current({
          resetValues: true,
          defaultValue: {
            actionTypeId: id,
            isDeprecated: false,
            config: {},
            secrets: {}
          }
        });
      }
    }
  };
  const [preSubmitValidationErrorMessage, setPreSubmitValidationErrorMessage] = (0, _react.useState)(null);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isSubmitting: false,
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {}
    }),
    preSubmitValidator: null
  });
  const {
    preSubmitValidator,
    submit,
    isValid: isFormValid,
    isSubmitting
  } = formState;
  const hasErrors = isFormValid === false;
  const isSaving = isSavingConnector || isSubmitting;
  const validateAndCreateConnector = (0, _react.useCallback)(async () => {
    setPreSubmitValidationErrorMessage(null);
    const {
      isValid,
      data
    } = await submit();
    if (!isMounted.current) {
      // User has closed the modal meanwhile submitting the form
      return;
    }
    if (isValid) {
      if (preSubmitValidator) {
        const validatorRes = await preSubmitValidator();
        if (validatorRes) {
          setPreSubmitValidationErrorMessage(validatorRes.message);
          return;
        }
      }

      /**
       * At this point the form is valid
       * and there are no pre submit error messages.
       */

      const {
        actionTypeId,
        name,
        config,
        secrets
      } = data;
      const validConnector = {
        actionTypeId,
        name: name !== null && name !== void 0 ? name : '',
        config,
        secrets
      };
      const createdConnector = await createConnector(validConnector);
      return createdConnector;
    }
  }, [submit, preSubmitValidator, createConnector]);
  const closeModal = (0, _react.useCallback)(() => {
    onClose();
  }, [onClose]);
  const onSubmit = (0, _react.useCallback)(async () => {
    const createdConnector = await validateAndCreateConnector();
    if (createdConnector) {
      closeModal();
      if (postSaveEventHandler) {
        postSaveEventHandler(createdConnector);
      }
    }
  }, [validateAndCreateConnector, closeModal, postSaveEventHandler]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        setLoadingActionTypes(true);
        const availableActionTypes = await (0, _action_connector_api.loadActionTypes)({
          http
        });
        setLoadingActionTypes(false);
        const index = {};
        for (const actionTypeItem of availableActionTypes) {
          index[actionTypeItem.id] = actionTypeItem;
        }
        setAllActionTypes(index);
      } catch (e) {
        if (toasts) {
          toasts.addDanger({
            title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionsConnectorsList.unableToLoadConnectorTypesMessage', {
              defaultMessage: 'Unable to load connector types'
            })
          });
        }
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    className: "actConnectorModal",
    "data-test-subj": "connectorAddModal",
    onClose: closeModal,
    style: {
      width: actionTypeRegistry.get(actionType.id).modalWidth
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, actionTypeModel && actionTypeModel.iconClass ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: actionTypeModel.iconClass,
    size: "xl"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    size: "s",
    component: "h3",
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{actionTypeName} connector",
    id: "xpack.triggersActionsUI.sections.addModalConnectorForm.flyoutTitle",
    values: {
      actionTypeName: actionType.name
    }
  }))), actionTypeModel && actionTypeModel.isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "betaBadgeFlexItem",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _beta_badge_props.betaBadgeProps.label,
    tooltipContent: _beta_badge_props.betaBadgeProps.tooltipContent
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, loadingActionTypes ? /*#__PURE__*/_react.default.createElement(_components.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.connectorAddModal.loadingConnectorTypesDescription",
    defaultMessage: "Loading connector types\u2026"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupActionTypeModel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "m",
    color: "primary",
    legend: "",
    options: groupActionButtons,
    idSelected: actionType.id,
    onChange: onChangeGroupAction,
    "data-test-subj": "slackTypeChangeButton"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), /*#__PURE__*/_react.default.createElement(_connector_form.ConnectorForm, {
    actionTypeModel: actionTypeModel,
    connector: initialConnector,
    isEdit: false,
    onChange: setFormState,
    setResetForm: setResetForm
  }), preSubmitValidationErrorMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    isLoading: isSaving
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.addModalConnectorForm.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), canSave ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "success",
    "data-test-subj": "saveActionButtonModal",
    type: "submit",
    iconType: "check",
    isLoading: isSaving,
    disabled: hasErrors,
    onClick: onSubmit
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.addModalConnectorForm.saveButtonLabel",
    defaultMessage: "Save"
  })) : null));
};

// eslint-disable-next-line import/no-default-export
exports.default = ConnectorAddModal;
module.exports = exports.default;