"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionTypeForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _parse_duration = require("@kbn/alerting-plugin/common/parse_duration");
var _beta_badge_props = require("./beta_badge_props");
var _types = require("../../../types");
var _check_action_type_enabled = require("../../lib/check_action_type_enabled");
var _capabilities = require("../../lib/capabilities");
var _action_variables = require("../../lib/action_variables");
var _kibana = require("../../../common/lib/kibana");
var _connectors_selection = require("./connectors_selection");
var _action_notify_when = require("./action_notify_when");
var _validate_params_for_warnings = require("../../lib/validate_params_for_warnings");
var _action_alerts_filter_timeframe = require("./action_alerts_filter_timeframe");
var _action_alerts_filter_query = require("./action_alerts_filter_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const preconfiguredMessage = _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionForm.preconfiguredTitleMessage', {
  defaultMessage: '(preconfigured)'
});
const ActionTypeForm = ({
  actionItem,
  actionConnector,
  index,
  onAddConnector,
  onConnectorSelected,
  onDeleteAction,
  setActionParamsProperty,
  setActionFrequencyProperty,
  setActionAlertsFilterProperty,
  actionTypesIndex,
  connectors,
  defaultActionGroupId,
  defaultActionMessage,
  messageVariables,
  summaryMessageVariables,
  actionGroups,
  setActionGroupIdByIndex,
  actionTypeRegistry,
  isActionGroupDisabledForActionType,
  recoveryActionGroup,
  hideNotifyWhen = false,
  defaultSummaryMessage,
  hasSummary,
  minimumThrottleInterval,
  notifyWhenSelectOptions,
  defaultNotifyWhenValue,
  showActionAlertsFilter
}) => {
  var _actionGroups$find, _actionItem$frequency, _actionItem$frequency2, _actionItem$frequency3, _actionItem$frequency4, _actionItem$frequency5, _actionTypeRegistered, _actionItem$frequency6, _actionItem$alertsFil, _actionItem$alertsFil2, _selectedActionGroup$, _actionItem$frequency7, _actionItem$frequency8;
  const {
    application: {
      capabilities
    },
    http: {
      basePath
    }
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isOpen, setIsOpen] = (0, _react.useState)(true);
  const [availableActionVariables, setAvailableActionVariables] = (0, _react.useState)([]);
  const defaultActionGroup = actionGroups === null || actionGroups === void 0 ? void 0 : actionGroups.find(({
    id
  }) => id === defaultActionGroupId);
  const selectedActionGroup = (_actionGroups$find = actionGroups === null || actionGroups === void 0 ? void 0 : actionGroups.find(({
    id
  }) => id === actionItem.group)) !== null && _actionGroups$find !== void 0 ? _actionGroups$find : defaultActionGroup;
  const [actionGroup, setActionGroup] = (0, _react.useState)();
  const [actionParamsErrors, setActionParamsErrors] = (0, _react.useState)({
    errors: {}
  });
  const [actionThrottle, setActionThrottle] = (0, _react.useState)((_actionItem$frequency = actionItem.frequency) !== null && _actionItem$frequency !== void 0 && _actionItem$frequency.throttle ? (0, _parse_duration.getDurationNumberInItsUnit)(actionItem.frequency.throttle) : null);
  const [actionThrottleUnit, setActionThrottleUnit] = (0, _react.useState)((_actionItem$frequency2 = actionItem.frequency) !== null && _actionItem$frequency2 !== void 0 && _actionItem$frequency2.throttle ? (0, _parse_duration.getDurationUnitValue)((_actionItem$frequency3 = actionItem.frequency) === null || _actionItem$frequency3 === void 0 ? void 0 : _actionItem$frequency3.throttle) : 'h');
  const [minimumActionThrottle = -1, minimumActionThrottleUnit] = minimumThrottleInterval !== null && minimumThrottleInterval !== void 0 ? minimumThrottleInterval : [-1, 's'];
  const [warning, setWarning] = (0, _react.useState)(null);
  const [useDefaultMessage, setUseDefaultMessage] = (0, _react.useState)(false);
  const isSummaryAction = (_actionItem$frequency4 = actionItem.frequency) === null || _actionItem$frequency4 === void 0 ? void 0 : _actionItem$frequency4.summary;
  const getDefaultParams = async () => {
    const connectorType = await actionTypeRegistry.get(actionItem.actionTypeId);
    let defaultParams;
    if (actionItem.group === recoveryActionGroup) {
      defaultParams = connectorType.defaultRecoveredActionParams;
    }
    if (!defaultParams) {
      defaultParams = connectorType.defaultActionParams;
    }
    return defaultParams;
  };
  const [showMinimumThrottleWarning, showMinimumThrottleUnitWarning] = (0, _react.useMemo)(() => {
    try {
      if (!actionThrottle) return [false, false];
      const throttleUnitDuration = (0, _parse_duration.parseDuration)(`1${actionThrottleUnit}`);
      const minThrottleUnitDuration = (0, _parse_duration.parseDuration)(`1${minimumActionThrottleUnit}`);
      const boundedThrottle = throttleUnitDuration > minThrottleUnitDuration ? actionThrottle : Math.max(actionThrottle, minimumActionThrottle);
      const boundedThrottleUnit = (0, _parse_duration.parseDuration)(`${actionThrottle}${actionThrottleUnit}`) >= minThrottleUnitDuration ? actionThrottleUnit : minimumActionThrottleUnit;
      return [boundedThrottle !== actionThrottle, boundedThrottleUnit !== actionThrottleUnit];
    } catch (e) {
      return [false, false];
    }
  }, [minimumActionThrottle, minimumActionThrottleUnit, actionThrottle, actionThrottleUnit]);
  (0, _react.useEffect)(() => {
    (async () => {
      setAvailableActionVariables(messageVariables ? getAvailableActionVariables(messageVariables, summaryMessageVariables, selectedActionGroup, isSummaryAction) : []);
      const defaultParams = await getDefaultParams();
      if (defaultParams) {
        for (const [key, paramValue] of Object.entries(defaultParams)) {
          if (actionItem.params[key] === undefined || actionItem.params[key] === null) {
            setActionParamsProperty(key, paramValue, index);
          }
        }
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionItem.group, (_actionItem$frequency5 = actionItem.frequency) === null || _actionItem$frequency5 === void 0 ? void 0 : _actionItem$frequency5.summary]);
  (0, _react.useEffect)(() => {
    (async () => {
      const defaultParams = await getDefaultParams();
      if (defaultParams && actionGroup) {
        for (const [key, paramValue] of Object.entries(defaultParams)) {
          setActionParamsProperty(key, paramValue, index);
        }
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionGroup]);
  (0, _react.useEffect)(() => {
    (async () => {
      var _actionTypeRegistry$g;
      const res = await ((_actionTypeRegistry$g = actionTypeRegistry.get(actionItem.actionTypeId)) === null || _actionTypeRegistry$g === void 0 ? void 0 : _actionTypeRegistry$g.validateParams(actionItem.params));
      setActionParamsErrors(res);
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionItem]);
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const actionGroupDisplay = (actionGroupId, actionGroupName, actionTypeId) => isActionGroupDisabledForActionType ? isActionGroupDisabledForActionType(actionGroupId, actionTypeId) ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.addNewActionConnectorActionGroup.display', {
    defaultMessage: '{actionGroupName} (Not Currently Supported)',
    values: {
      actionGroupName
    }
  }) : actionGroupName : actionGroupName;
  const isActionGroupDisabled = (actionGroupId, actionTypeId) => isActionGroupDisabledForActionType ? isActionGroupDisabledForActionType(actionGroupId, actionTypeId) : false;
  const actionNotifyWhen = /*#__PURE__*/_react.default.createElement(_action_notify_when.ActionNotifyWhen, {
    frequency: actionItem.frequency,
    throttle: actionThrottle,
    throttleUnit: actionThrottleUnit,
    hasSummary: hasSummary,
    onNotifyWhenChange: (0, _react.useCallback)(notifyWhen => {
      setActionFrequencyProperty('notifyWhen', notifyWhen, index);
    }, [setActionFrequencyProperty, index]),
    onThrottleChange: (0, _react.useCallback)((throttle, throttleUnit) => {
      if (throttle) {
        setActionThrottle(throttle);
        setActionThrottleUnit(throttleUnit);
      }
      setActionFrequencyProperty('throttle', throttle ? `${throttle}${throttleUnit}` : null, index);
    }, [setActionFrequencyProperty, index]),
    onSummaryChange: (0, _react.useCallback)(summary => {
      // use the default message when a user toggles between action frequencies
      setUseDefaultMessage(true);
      setActionFrequencyProperty('summary', summary, index);
    }, [setActionFrequencyProperty, index]),
    showMinimumThrottleWarning: showMinimumThrottleWarning,
    showMinimumThrottleUnitWarning: showMinimumThrottleUnitWarning,
    notifyWhenSelectOptions: notifyWhenSelectOptions,
    defaultNotifyWhenValue: defaultNotifyWhenValue
  });
  const actionTypeRegistered = actionTypeRegistry.get(actionConnector.actionTypeId);
  if (!actionTypeRegistered) return null;
  const allowGroupConnector = ((_actionTypeRegistered = actionTypeRegistered === null || actionTypeRegistered === void 0 ? void 0 : actionTypeRegistered.subtype) !== null && _actionTypeRegistered !== void 0 ? _actionTypeRegistered : []).map(atr => atr.id);
  const showActionGroupErrorIcon = () => {
    return !isOpen && (0, _lodash.some)(actionParamsErrors.errors, error => !(0, _lodash.isEmpty)(error));
  };
  const ParamsFieldsComponent = actionTypeRegistered.actionParamsFields;
  const checkEnabledResult = (0, _check_action_type_enabled.checkActionFormActionTypeEnabled)(actionTypesIndex[actionConnector.actionTypeId], connectors.filter(connector => connector.isPreconfigured));
  const showSelectActionGroup = actionGroups && selectedActionGroup && setActionGroupIdByIndex && !((_actionItem$frequency6 = actionItem.frequency) !== null && _actionItem$frequency6 !== void 0 && _actionItem$frequency6.summary);
  const accordionContent = checkEnabledResult.isEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    style: {
      borderBottom: `1px solid ${euiTheme.colors.lightShade}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.actionTypeForm.actionIdLabel",
      defaultMessage: "{connectorInstance} connector",
      values: {
        connectorInstance: actionTypesIndex ? actionTypesIndex[actionConnector.actionTypeId].name : actionConnector.actionTypeId
      }
    }),
    labelAppend: canSave && actionTypesIndex && actionTypesIndex[actionConnector.actionTypeId].enabledInConfig ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": `addNewActionConnectorButton-${actionItem.actionTypeId}`,
      onClick: onAddConnector
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Add connector",
      id: "xpack.triggersActionsUI.sections.actionTypeForm.addNewConnectorEmptyButton"
    })) : null
  }, /*#__PURE__*/_react.default.createElement(_connectors_selection.ConnectorsSelection, {
    allowGroupConnector: allowGroupConnector,
    actionItem: actionItem,
    accordionIndex: index,
    actionTypesIndex: actionTypesIndex,
    actionTypeRegistered: actionTypeRegistered,
    connectors: connectors,
    onConnectorSelected: onConnectorSelected
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), !hideNotifyWhen && actionNotifyWhen, showSelectActionGroup && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideNotifyWhen && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      htmlFor: `addNewActionConnectorActionGroup-${actionItem.actionTypeId}`
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.actionTypeForm.actionRunWhenInActionGroup",
      defaultMessage: "Run when"
    })),
    fullWidth: true,
    id: `addNewActionConnectorActionGroup-${actionItem.actionTypeId}`,
    "data-test-subj": `addNewActionConnectorActionGroup-${index}`,
    options: actionGroups.map(({
      id: value,
      name
    }) => ({
      value,
      inputDisplay: actionGroupDisplay(value, name, actionItem.actionTypeId),
      disabled: isActionGroupDisabled(value, actionItem.actionTypeId),
      'data-test-subj': `addNewActionConnectorActionGroup-${index}-option-${value}`
    })),
    valueOfSelected: selectedActionGroup.id,
    onChange: group => {
      setActionGroupIdByIndex(group, index);
      setActionGroup(group);
    }
  })), showActionAlertsFilter && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideNotifyWhen && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_action_alerts_filter_query.ActionAlertsFilterQuery, {
    state: (_actionItem$alertsFil = actionItem.alertsFilter) === null || _actionItem$alertsFil === void 0 ? void 0 : _actionItem$alertsFil.query,
    onChange: query => setActionAlertsFilterProperty('query', query, index)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_action_alerts_filter_timeframe.ActionAlertsFilterTimeframe, {
    state: (_actionItem$alertsFil2 = actionItem.alertsFilter) === null || _actionItem$alertsFil2 === void 0 ? void 0 : _actionItem$alertsFil2.timeframe,
    onChange: timeframe => setActionAlertsFilterProperty('timeframe', timeframe, index)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "plain"
  }, ParamsFieldsComponent ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(ParamsFieldsComponent, {
    actionParams: actionItem.params,
    index: index,
    errors: actionParamsErrors.errors,
    editAction: (key, value, i) => {
      setWarning((0, _validate_params_for_warnings.validateParamsForWarnings)(value, basePath.publicBaseUrl, availableActionVariables));
      setActionParamsProperty(key, value, i);
    },
    messageVariables: availableActionVariables,
    defaultMessage:
    // if action is a summary action, show the default summary message
    isSummaryAction ? defaultSummaryMessage : (_selectedActionGroup$ = selectedActionGroup === null || selectedActionGroup === void 0 ? void 0 : selectedActionGroup.defaultActionMessage) !== null && _selectedActionGroup$ !== void 0 ? _selectedActionGroup$ : defaultActionMessage,
    useDefaultMessage: useDefaultMessage,
    actionConnector: actionConnector,
    executionMode: _types.ActionConnectorMode.ActionForm
  }), warning ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: warning
  })) : null)) : null)) : checkEnabledResult.messageCard;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: isOpen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    key: index,
    id: index.toString(),
    onToggle: setIsOpen,
    paddingSize: "none",
    className: "actAccordionActionForm",
    buttonContentClassName: "actAccordionActionForm__button",
    "data-test-subj": `alertActionAccordion-${index}`,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, showActionGroupErrorIcon() ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.actionErrorToolTip', {
        defaultMessage: 'Action contains errors.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "action-group-error-icon",
      type: "warning",
      color: "danger",
      size: "m"
    }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: actionTypeRegistered.iconClass,
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "{actionConnectorName}",
      id: "xpack.triggersActionsUI.sections.actionTypeForm.existingAlertActionTypeEditTitle",
      values: {
        actionConnectorName: `${actionConnector.name} ${actionConnector.isPreconfigured ? preconfiguredMessage : ''}`
      }
    })), (selectedActionGroup || ((_actionItem$frequency7 = actionItem.frequency) === null || _actionItem$frequency7 === void 0 ? void 0 : _actionItem$frequency7.summary)) && !isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: "clock"
    }, (_actionItem$frequency8 = actionItem.frequency) !== null && _actionItem$frequency8 !== void 0 && _actionItem$frequency8.summary ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.summaryGroupTitle', {
      defaultMessage: 'Summary of alerts'
    }) : _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.runWhenGroupTitle', {
      defaultMessage: 'Run when {groupName}',
      values: {
        groupName: selectedActionGroup.name.toLocaleLowerCase()
      }
    }))), warning && !isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "warning-badge",
      iconType: "warning",
      color: "warning"
    }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.actionWarningsTitle', {
      defaultMessage: '1 warning'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, checkEnabledResult.isEnabled === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "warning",
      color: "danger",
      content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.actionDisabledTitle', {
        defaultMessage: 'This action is disabled'
      }),
      position: "right"
    }))))))), actionTypeRegistered && actionTypeRegistered.isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      "data-test-subj": "action-type-form-beta-badge",
      label: _beta_badge_props.betaBadgeProps.label,
      tooltipContent: _beta_badge_props.betaBadgeProps.tooltipContent
    }))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "minusInCircle",
      color: "danger",
      className: "actAccordionActionForm__extraAction",
      "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.accordion.deleteIconAriaLabel', {
        defaultMessage: 'Delete'
      }),
      onClick: onDeleteAction
    })
  }, accordionContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
exports.ActionTypeForm = ActionTypeForm;
function getAvailableActionVariables(actionVariables, summaryActionVariables, actionGroup, isSummaryAction) {
  const transformedActionVariables = (0, _action_variables.transformActionVariables)(actionVariables, summaryActionVariables, actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.omitMessageVariables, isSummaryAction);

  // partition deprecated items so they show up last
  const partitionedActionVariables = (0, _lodash.partition)(transformedActionVariables, v => v.deprecated !== true);
  return partitionedActionVariables.reduce((acc, curr) => {
    return [...acc, ...curr.sort((a, b) => a.name.toUpperCase().localeCompare(b.name.toUpperCase()))];
  }, []);
}