"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NOTIFY_WHEN_OPTIONS = exports.ActionNotifyWhen = void 0;
var _common = require("@kbn/alerting-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common2 = require("@kbn/kibana-react-plugin/common");
var _eui = require("@elastic/eui");
var _Option = require("fp-ts/lib/Option");
var _pipeable = require("fp-ts/lib/pipeable");
var _get_time_options = require("../../../common/lib/get_time_options");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NOTIFY_WHEN_OPTIONS = [{
  isSummaryOption: false,
  isForEachAlertOption: true,
  value: {
    value: 'onActionGroupChange',
    inputDisplay: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActionGroupChange.display', {
      defaultMessage: 'On status changes'
    }),
    'data-test-subj': 'onActionGroupChange',
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "On status changes",
      id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActionGroupChange.label"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Actions run if the alert status changes.",
      id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActionGroupChange.description"
    }))))
  }
}, {
  isSummaryOption: true,
  isForEachAlertOption: true,
  value: {
    value: 'onActiveAlert',
    inputDisplay: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActiveAlert.display', {
      defaultMessage: 'On check intervals'
    }),
    'data-test-subj': 'onActiveAlert',
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "On check intervals",
      id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActiveAlert.label"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Actions run if rule conditions are met.",
      id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActiveAlert.description"
    }))))
  }
}, {
  isSummaryOption: true,
  isForEachAlertOption: true,
  value: {
    value: 'onThrottleInterval',
    inputDisplay: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onThrottleInterval.display', {
      defaultMessage: 'On custom action intervals'
    }),
    'data-test-subj': 'onThrottleInterval',
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "On custom action intervals",
      id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onThrottleInterval.label"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Actions run if rule conditions are met.",
      id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onThrottleInterval.description"
    }))))
  }
}];
exports.NOTIFY_WHEN_OPTIONS = NOTIFY_WHEN_OPTIONS;
const ActionNotifyWhen = ({
  hasSummary,
  frequency = _constants.DEFAULT_FREQUENCY,
  throttle,
  throttleUnit,
  onNotifyWhenChange,
  onThrottleChange,
  onSummaryChange,
  showMinimumThrottleWarning,
  showMinimumThrottleUnitWarning,
  notifyWhenSelectOptions = NOTIFY_WHEN_OPTIONS,
  defaultNotifyWhenValue = _constants.DEFAULT_FREQUENCY.notifyWhen
}) => {
  const [showCustomThrottleOpts, setShowCustomThrottleOpts] = (0, _react.useState)(false);
  const [notifyWhenValue, setNotifyWhenValue] = (0, _react.useState)(defaultNotifyWhenValue);
  const [summaryMenuOpen, setSummaryMenuOpen] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (frequency.notifyWhen) {
      setNotifyWhenValue(frequency.notifyWhen);
    } else {
      // If 'notifyWhen' is not set, derive value from existence of throttle value
      setNotifyWhenValue(frequency.throttle ? _common.RuleNotifyWhen.THROTTLE : _common.RuleNotifyWhen.ACTIVE);
    }
  }, [frequency]);
  (0, _react.useEffect)(() => {
    setShowCustomThrottleOpts(notifyWhenValue === _common.RuleNotifyWhen.THROTTLE);
  }, [notifyWhenValue]);
  const onNotifyWhenValueChange = (0, _react.useCallback)(newValue => {
    onNotifyWhenChange(newValue);
    setNotifyWhenValue(newValue);
    // Calling onNotifyWhenChange and onThrottleChange at the same time interferes with the React state lifecycle
    // so wait for onNotifyWhenChange to process before calling onThrottleChange
    setTimeout(() => onThrottleChange(newValue === _common.RuleNotifyWhen.THROTTLE ? throttle !== null && throttle !== void 0 ? throttle : 1 : null, throttleUnit), 100);
  }, [onNotifyWhenChange, onThrottleChange, throttle, throttleUnit]);
  const summaryNotifyWhenOptions = (0, _react.useMemo)(() => notifyWhenSelectOptions.filter(o => o.isSummaryOption).map(o => o.value), [notifyWhenSelectOptions]);
  const forEachAlertNotifyWhenOptions = (0, _react.useMemo)(() => notifyWhenSelectOptions.filter(o => o.isForEachAlertOption).map(o => o.value), [notifyWhenSelectOptions]);
  const notifyWhenOptions = (0, _react.useMemo)(() => frequency.summary ? summaryNotifyWhenOptions : forEachAlertNotifyWhenOptions, [forEachAlertNotifyWhenOptions, frequency.summary, summaryNotifyWhenOptions]);
  const selectedOptionDoesNotExist = (0, _react.useCallback)(summary => summary && !summaryNotifyWhenOptions.filter(o => o.value === frequency.notifyWhen).length || !summary && !forEachAlertNotifyWhenOptions.filter(o => o.value === frequency.notifyWhen).length, [forEachAlertNotifyWhenOptions, frequency.notifyWhen, summaryNotifyWhenOptions]);
  const getDefaultNotifyWhenOption = (0, _react.useCallback)(summary => {
    if (summary) {
      return summaryNotifyWhenOptions.length ? summaryNotifyWhenOptions[0].value : _common.RuleNotifyWhen.ACTIVE;
    }
    return forEachAlertNotifyWhenOptions.length ? forEachAlertNotifyWhenOptions[0].value : _common.RuleNotifyWhen.ACTIVE;
  }, [forEachAlertNotifyWhenOptions, summaryNotifyWhenOptions]);
  const selectSummaryOption = (0, _react.useCallback)(summary => {
    onSummaryChange(summary);
    setSummaryMenuOpen(false);
    if (selectedOptionDoesNotExist(summary)) {
      onNotifyWhenChange(getDefaultNotifyWhenOption(summary));
    }
  }, [onSummaryChange, selectedOptionDoesNotExist, onNotifyWhenChange, getDefaultNotifyWhenOption]);
  const summaryOptions = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(SummaryContextMenuOption, {
    className: "euiSuperSelect__item",
    key: "summary",
    onClick: () => selectSummaryOption(true),
    icon: frequency.summary ? 'check' : 'empty',
    id: "actionNotifyWhen-option-summary",
    "data-test-subj": "actionNotifyWhen-option-summary"
  }, SUMMARY_OF_ALERTS), /*#__PURE__*/_react.default.createElement(SummaryContextMenuOption, {
    className: "euiSuperSelect__item",
    key: "for_each",
    onClick: () => selectSummaryOption(false),
    icon: !frequency.summary ? 'check' : 'empty',
    id: "actionNotifyWhen-option-for_each",
    "data-test-subj": "actionNotifyWhen-option-for_each"
  }, FOR_EACH_ALERT)], [frequency.summary, selectSummaryOption]);
  const summaryOrPerRuleSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "summaryOrPerRuleSelect",
    initialFocus: `#actionNotifyWhen-option-${frequency.summary ? 'summary' : 'for_each'}`,
    isOpen: summaryMenuOpen,
    closePopover: (0, _react.useCallback)(() => setSummaryMenuOpen(false), [setSummaryMenuOpen]),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "aria-label": frequency.summary ? SUMMARY_OF_ALERTS : FOR_EACH_ALERT,
    "aria-roledescription": _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.actionNotifyWhen.summaryOrRulePerSelectRoleDescription', {
      defaultMessage: 'Action frequency type select'
    }),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: (0, _react.useCallback)(() => setSummaryMenuOpen(!summaryMenuOpen), [summaryMenuOpen])
    }, frequency.summary ? SUMMARY_OF_ALERTS : FOR_EACH_ALERT)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: summaryOptions
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.actionNotifyWhen.actionFrequencyLabel', {
      defaultMessage: 'Action frequency'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    prepend: hasSummary ? summaryOrPerRuleSelect : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    "data-test-subj": "notifyWhenSelect",
    options: notifyWhenOptions,
    valueOfSelected: notifyWhenValue,
    onChange: onNotifyWhenValueChange
  }), showCustomThrottleOpts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      flexGrow: 0.1
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: showMinimumThrottleWarning,
    min: 1,
    value: throttle !== null && throttle !== void 0 ? throttle : 1,
    name: "throttle",
    "data-test-subj": "throttleInput",
    prepend: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.frequencyNotifyWhen.label', {
      defaultMessage: 'Run every'
    }),
    onChange: e => {
      (0, _pipeable.pipe)((0, _Option.some)(e.target.value.trim()), (0, _Option.filter)(value => value !== ''), (0, _Option.map)(value => parseInt(value, 10)), (0, _Option.filter)(value => !isNaN(value)), (0, _Option.map)(value => {
        onThrottleChange(value, throttleUnit);
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    isInvalid: showMinimumThrottleUnitWarning,
    "data-test-subj": "throttleUnitInput",
    value: throttleUnit,
    options: (0, _get_time_options.getTimeOptions)(throttle !== null && throttle !== void 0 ? throttle : 1),
    onChange: e => {
      onThrottleChange(throttle, e.target.value);
    }
  })))), (showMinimumThrottleWarning || showMinimumThrottleUnitWarning) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.notifyWhenThrottleWarning', {
    defaultMessage: "Custom action intervals cannot be shorter than the rule's check interval"
  })))))));
};
exports.ActionNotifyWhen = ActionNotifyWhen;
const FOR_EACH_ALERT = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.actionNotifyWhen.forEachOption', {
  defaultMessage: 'For each alert'
});
const SUMMARY_OF_ALERTS = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.actionNotifyWhen.summaryOption', {
  defaultMessage: 'Summary of alerts'
});
const SummaryContextMenuOption = (0, _common2.euiStyled)(_eui.EuiContextMenuItem)`
  min-width: 300px;
`;