"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorWithInvalidatedFields = getConnectorWithInvalidatedFields;
exports.getRuleWithInvalidatedFields = getRuleWithInvalidatedFields;
exports.isValidUrl = void 0;
exports.throwIfAbsent = throwIfAbsent;
exports.throwIfIsntContained = throwIfIsntContained;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function throwIfAbsent(message) {
  return value => {
    if (value === undefined || value === null) {
      throw new Error(message);
    }
    return value;
  };
}
function throwIfIsntContained(requiredValues, message, valueExtractor) {
  const toError = typeof message === 'function' ? message : (0, _lodash.constant)(message);
  return values => {
    const availableValues = new Set(values.map(valueExtractor));
    for (const value of requiredValues.values()) {
      if (!availableValues.has(value)) {
        throw new Error(toError(value));
      }
    }
    return values;
  };
}
const isValidUrl = (urlString, protocol) => {
  try {
    const urlObject = new URL(urlString);
    if (protocol === undefined || urlObject.protocol === protocol) {
      return true;
    }
    return false;
  } catch (err) {
    return false;
  }
};
exports.isValidUrl = isValidUrl;
function getConnectorWithInvalidatedFields(connector, configErrors, secretsErrors, baseConnectorErrors) {
  Object.keys(configErrors).forEach(errorKey => {
    if (configErrors[errorKey].length >= 1 && (0, _lodash.get)(connector.config, errorKey) === undefined) {
      (0, _saferLodashSet.set)(connector.config, errorKey, null);
    }
  });
  Object.keys(secretsErrors).forEach(errorKey => {
    if (secretsErrors[errorKey].length >= 1 && (0, _lodash.get)(connector.secrets, errorKey) === undefined) {
      (0, _saferLodashSet.set)(connector.secrets, errorKey, null);
    }
  });
  Object.keys(baseConnectorErrors).forEach(errorKey => {
    if (baseConnectorErrors[errorKey].length >= 1 && (0, _lodash.get)(connector, errorKey) === undefined) {
      (0, _saferLodashSet.set)(connector, errorKey, null);
    }
  });
  return connector;
}
function getRuleWithInvalidatedFields(rule, paramsErrors, baseAlertErrors, actionsErrors) {
  Object.keys(paramsErrors).forEach(errorKey => {
    if (paramsErrors[errorKey].length >= 1 && (0, _lodash.get)(rule.params, errorKey) === undefined) {
      (0, _saferLodashSet.set)(rule.params, errorKey, null);
    }
  });
  Object.keys(baseAlertErrors).forEach(errorKey => {
    if (baseAlertErrors[errorKey].length >= 1 && (0, _lodash.get)(rule, errorKey) === undefined) {
      (0, _saferLodashSet.set)(rule, errorKey, null);
    }
  });
  actionsErrors.forEach((error, index) => {
    const actionToValidate = rule.actions.length > index ? rule.actions[index] : null;
    if (actionToValidate) {
      Object.keys(error).forEach(errorKey => {
        if (error[errorKey].length >= 1 && (0, _lodash.get)(actionToValidate.params, errorKey) === undefined) {
          (0, _saferLodashSet.set)(actionToValidate.params, errorKey, null);
        }
      });
    }
  });
  return rule;
}