"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateRule = updateRule;
var _lodash = require("lodash");
var _constants = require("../../constants");
var _common_transformations = require("./common_transformations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRequest = ({
  actions,
  ...res
}) => ({
  ...res,
  actions: actions.map(({
    group,
    id,
    params,
    frequency,
    uuid,
    alertsFilter
  }) => ({
    group,
    id,
    params,
    frequency: {
      notify_when: frequency.notifyWhen,
      throttle: frequency.throttle,
      summary: frequency.summary
    },
    alerts_filter: alertsFilter,
    ...(uuid && {
      uuid
    })
  }))
});
async function updateRule({
  http,
  rule,
  id
}) {
  const res = await http.put(`${_constants.BASE_ALERTING_API_PATH}/rule/${encodeURIComponent(id)}`, {
    body: JSON.stringify(rewriteBodyRequest((0, _lodash.pick)(rule, ['name', 'tags', 'schedule', 'params', 'actions'])))
  });
  return (0, _common_transformations.transformRule)(res);
}