"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapFiltersToKueryNode = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapFiltersToKueryNode = ({
  typesFilter,
  actionTypesFilter,
  ruleExecutionStatusesFilter,
  ruleLastRunOutcomesFilter,
  ruleParamsFilter,
  ruleStatusesFilter,
  tagsFilter,
  searchText
}) => {
  const filterKueryNode = [];
  if (typesFilter && typesFilter.length) {
    filterKueryNode.push(_esQuery.nodeBuilder.or(typesFilter.map(tf => _esQuery.nodeBuilder.is('alert.attributes.alertTypeId', tf))));
  }
  if (actionTypesFilter && actionTypesFilter.length) {
    filterKueryNode.push(_esQuery.nodeBuilder.or(actionTypesFilter.map(atf => (0, _esQuery.fromKueryExpression)(`alert.attributes.actions:{ actionTypeId: ${atf} }`))));
  }
  if (ruleExecutionStatusesFilter && ruleExecutionStatusesFilter.length) {
    filterKueryNode.push(_esQuery.nodeBuilder.or(ruleExecutionStatusesFilter.map(resf => _esQuery.nodeBuilder.is('alert.attributes.executionStatus.status', resf))));
  }
  if (ruleLastRunOutcomesFilter && ruleLastRunOutcomesFilter.length) {
    filterKueryNode.push(_esQuery.nodeBuilder.or(ruleLastRunOutcomesFilter.map(resf => _esQuery.nodeBuilder.is('alert.attributes.lastRun.outcome', resf))));
  }
  if (ruleParamsFilter && Object.keys(ruleParamsFilter).length) {
    filterKueryNode.push(_esQuery.nodeBuilder.and(Object.keys(ruleParamsFilter).map(ruleParam => _esQuery.nodeBuilder.is(`alert.attributes.params.${ruleParam}`, String(ruleParamsFilter[ruleParam])))));
  }
  if (ruleStatusesFilter && ruleStatusesFilter.length) {
    const snoozedFilter = _esQuery.nodeBuilder.or([(0, _esQuery.fromKueryExpression)('alert.attributes.muteAll: true'), (0, _esQuery.fromKueryExpression)('alert.attributes.snoozeSchedule:{ duration > 0 }')]);
    const enabledFilter = (0, _esQuery.fromKueryExpression)('alert.attributes.enabled: true');
    const disabledFilter = (0, _esQuery.fromKueryExpression)('alert.attributes.enabled: false');
    const ruleStatusesFilterKueryNode = [];
    if (ruleStatusesFilter.includes('enabled')) {
      ruleStatusesFilterKueryNode.push(enabledFilter);
    }
    if (ruleStatusesFilter.includes('disabled')) {
      ruleStatusesFilterKueryNode.push(disabledFilter);
    }
    if (ruleStatusesFilter.includes('snoozed')) {
      ruleStatusesFilterKueryNode.push(snoozedFilter);
    }
    filterKueryNode.push(_esQuery.nodeBuilder.or(ruleStatusesFilterKueryNode));
  }
  if (tagsFilter && tagsFilter.length) {
    filterKueryNode.push(_esQuery.nodeBuilder.or(tagsFilter.map(tag => _esQuery.nodeBuilder.is('alert.attributes.tags', tag))));
  }
  if (searchText && searchText !== '') {
    // if the searchText includes quotes, treat it as an exact match query
    const value = searchText.match(/(['"`])(.*?)\1/g) ? _esQuery.nodeTypes.literal.buildNode(searchText, true) : _esQuery.nodeTypes.wildcard.buildNode(searchText);
    filterKueryNode.push(_esQuery.nodeBuilder.or([_esQuery.nodeBuilder.is('alert.attributes.name', value), _esQuery.nodeBuilder.is('alert.attributes.tags', value)]));
  }
  return filterKueryNode.length ? _esQuery.nodeBuilder.and(filterKueryNode) : null;
};
exports.mapFiltersToKueryNode = mapFiltersToKueryNode;