"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadGlobalExecutionKPIAggregations = void 0;
var _constants = require("../../constants");
var _get_filter = require("./get_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadGlobalExecutionKPIAggregations = ({
  id,
  http,
  outcomeFilter,
  message,
  dateStart,
  dateEnd,
  namespaces
}) => {
  const filter = (0, _get_filter.getFilter)({
    outcomeFilter,
    message
  });
  return http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/_global_execution_kpi`, {
    query: {
      filter: filter.length ? filter.join(' and ') : undefined,
      date_start: dateStart,
      date_end: dateEnd,
      namespaces: namespaces ? JSON.stringify(namespaces) : namespaces
    }
  });
};
exports.loadGlobalExecutionKPIAggregations = loadGlobalExecutionKPIAggregations;