"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadGlobalExecutionLogAggregations = exports.loadExecutionLogAggregations = void 0;
var _constants = require("../../constants");
var _get_filter = require("./get_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

const getRenamedLog = data => {
  const {
    duration_ms,
    total_search_duration_ms,
    es_search_duration_ms,
    schedule_delay_ms,
    ...rest
  } = data;
  return {
    execution_duration: data.duration_ms,
    total_search_duration: data.total_search_duration_ms,
    es_search_duration: data.es_search_duration_ms,
    schedule_delay: data.schedule_delay_ms,
    ...rest
  };
};
const rewriteBodyRes = ({
  data,
  ...rest
}) => ({
  data: data.map(log => getRenamedLog(log)),
  ...rest
});
const loadExecutionLogAggregations = async ({
  id,
  http,
  dateStart,
  dateEnd,
  outcomeFilter,
  message,
  perPage = 10,
  page = 0,
  sort = []
}) => {
  const sortField = sort;
  const filter = (0, _get_filter.getFilter)({
    outcomeFilter,
    message
  });
  const result = await http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rule/${id}/_execution_log`, {
    query: {
      date_start: dateStart,
      date_end: dateEnd,
      filter: filter.length ? filter.join(' and ') : undefined,
      per_page: perPage,
      // Need to add the + 1 for pages because APIs are 1 indexed,
      // whereas data grid sorts are 0 indexed.
      page: page + 1,
      sort: sortField.length ? JSON.stringify(sortField) : undefined
    }
  });
  return rewriteBodyRes(result);
};
exports.loadExecutionLogAggregations = loadExecutionLogAggregations;
const loadGlobalExecutionLogAggregations = async ({
  http,
  dateStart,
  dateEnd,
  outcomeFilter,
  message,
  perPage = 10,
  page = 0,
  sort = [],
  namespaces
}) => {
  const sortField = sort;
  const filter = (0, _get_filter.getFilter)({
    outcomeFilter,
    message
  });
  const result = await http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/_global_execution_logs`, {
    query: {
      date_start: dateStart,
      date_end: dateEnd,
      filter: filter.length ? filter.join(' and ') : undefined,
      per_page: perPage,
      // Need to add the + 1 for pages because APIs are 1 indexed,
      // whereas data grid sorts are 0 indexed.
      page: page + 1,
      sort: sortField.length ? JSON.stringify(sortField) : undefined,
      namespaces: namespaces ? JSON.stringify(namespaces) : undefined
    }
  });
  return rewriteBodyRes(result);
};
exports.loadGlobalExecutionLogAggregations = loadGlobalExecutionLogAggregations;