"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlappingSettings = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRes = ({
  look_back_window: lookBackWindow,
  status_change_threshold: statusChangeThreshold,
  ...rest
}) => ({
  ...rest,
  lookBackWindow,
  statusChangeThreshold
});
const getFlappingSettings = async ({
  http
}) => {
  const res = await http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_flapping`);
  return rewriteBodyRes(res);
};
exports.getFlappingSettings = getFlappingSettings;