"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRuleAggregations = loadRuleAggregations;
exports.loadRuleTags = loadRuleTags;
var _constants = require("../../constants");
var _map_filters_to_kql = require("./map_filters_to_kql");
var _aggregate_helpers = require("./aggregate_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: https://github.com/elastic/kibana/issues/131682
async function loadRuleTags({
  http
}) {
  const res = await http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/_aggregate`);
  return (0, _aggregate_helpers.rewriteTagsBodyRes)(res);
}
async function loadRuleAggregations({
  http,
  searchText,
  typesFilter,
  actionTypesFilter,
  ruleExecutionStatusesFilter,
  ruleStatusesFilter,
  tagsFilter
}) {
  const filters = (0, _map_filters_to_kql.mapFiltersToKql)({
    typesFilter,
    actionTypesFilter,
    ruleExecutionStatusesFilter,
    ruleStatusesFilter,
    tagsFilter
  });
  const res = await http.post(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/_aggregate`, {
    body: JSON.stringify({
      search_fields: searchText ? JSON.stringify(['name', 'tags']) : undefined,
      search: searchText,
      filter: filters.length ? filters.join(' and ') : undefined,
      default_search_operator: 'AND'
    })
  });
  return (0, _aggregate_helpers.rewriteBodyRes)(res);
}