"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadAllActions = loadAllActions;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteResponseRes = results => {
  return results.map(item => transformConnector(item));
};
const transformConnector = ({
  connector_type_id: actionTypeId,
  is_preconfigured: isPreconfigured,
  is_deprecated: isDeprecated,
  referenced_by_count: referencedByCount,
  is_missing_secrets: isMissingSecrets,
  ...res
}) => ({
  actionTypeId,
  isPreconfigured,
  isDeprecated,
  referencedByCount,
  isMissingSecrets,
  ...res
});
async function loadAllActions({
  http
}) {
  const res = await http.get(`${_constants.BASE_ACTION_API_PATH}/connectors`);
  return rewriteResponseRes(res);
}