"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadActionTypes = loadActionTypes;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteResponseRes = results => {
  return results.map(item => rewriteBodyReq(item));
};
const rewriteBodyReq = ({
  enabled_in_config: enabledInConfig,
  enabled_in_license: enabledInLicense,
  minimum_license_required: minimumLicenseRequired,
  supported_feature_ids: supportedFeatureIds,
  ...res
}) => ({
  enabledInConfig,
  enabledInLicense,
  minimumLicenseRequired,
  supportedFeatureIds,
  ...res
});
async function loadActionTypes({
  http,
  featureId
}) {
  const res = featureId ? await http.get(`${_constants.BASE_ACTION_API_PATH}/connector_types`, {
    query: {
      feature_id: featureId
    }
  }) : await http.get(`${_constants.BASE_ACTION_API_PATH}/connector_types`);
  return rewriteResponseRes(res);
}