"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadTagsQuery = useLoadTagsQuery;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _aggregate = require("../lib/rule_api/aggregate");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLoadTagsQuery(props) {
  var _data$ruleTags;
  const {
    enabled,
    refresh
  } = props;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const queryFn = () => {
    return (0, _aggregate.loadRuleTags)({
      http
    });
  };
  const onErrorFn = () => {
    toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.unableToLoadRuleTags', {
      defaultMessage: 'Unable to load rule tags'
    }));
  };
  const {
    refetch,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadRuleTags', {
      refresh: refresh === null || refresh === void 0 ? void 0 : refresh.toDateString()
    }],
    queryFn,
    onError: onErrorFn,
    enabled,
    refetchOnWindowFocus: false
  });
  return {
    tags: (_data$ruleTags = data === null || data === void 0 ? void 0 : data.ruleTags) !== null && _data$ruleTags !== void 0 ? _data$ruleTags : [],
    loadTags: refetch
  };
}