"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadRuleTypes = useLoadRuleTypes;
var _react = require("react");
var _rule_types = require("../lib/rule_api/rule_types");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLoadRuleTypes({
  filteredRuleTypes
}) {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const isMounted = (0, _react.useRef)(false);
  const [ruleTypesState, setRuleTypesState] = (0, _react.useState)({
    isLoading: true,
    data: [],
    error: null
  });
  const [ruleTypeIndex, setRuleTypeIndex] = (0, _react.useState)(new Map());
  async function fetchRuleTypes() {
    try {
      const response = await (0, _rule_types.loadRuleTypes)({
        http
      });
      const index = new Map();
      for (const ruleTypeItem of response) {
        index.set(ruleTypeItem.id, ruleTypeItem);
      }
      if (isMounted.current) {
        setRuleTypeIndex(index);
        let filteredResponse = response;
        if (filteredRuleTypes && filteredRuleTypes.length > 0) {
          filteredResponse = response.filter(item => filteredRuleTypes.includes(item.id));
        }
        setRuleTypesState({
          ...ruleTypesState,
          isLoading: false,
          data: filteredResponse
        });
      }
    } catch (e) {
      if (isMounted.current) {
        setRuleTypesState({
          ...ruleTypesState,
          isLoading: false,
          error: e
        });
      }
    }
  }
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    fetchRuleTypes();
    return () => {
      isMounted.current = false;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    ruleTypes: ruleTypesState.data,
    error: ruleTypesState.error,
    ruleTypeIndex,
    ruleTypesIsLoading: ruleTypesState.isLoading
  };
}