"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadConfigQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../common/lib/kibana");
var _config_api = require("../../common/lib/config_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLoadConfigQuery = () => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadConfig'],
    queryFn: () => {
      return (0, _config_api.triggersActionsUiConfig)({
        http
      });
    },
    initialData: {
      isUsingSecurity: false
    },
    refetchOnWindowFocus: false
  });
  return {
    config: data
  };
};
exports.useLoadConfigQuery = useLoadConfigQuery;