"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchRuleActionConnectors = useFetchRuleActionConnectors;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _action_connector_api = require("../lib/action_connector_api");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTIONS_LOAD_ERROR = errorMessage => _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.connectorsLoadError', {
  defaultMessage: 'Unable to load rule actions connectors. Reason: {message}',
  values: {
    message: errorMessage
  }
});
function useFetchRuleActionConnectors({
  ruleActions
}) {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [actionConnectors, setActionConnector] = (0, _react.useState)({
    isLoadingActionConnectors: true,
    actionConnectors: [],
    errorActionConnectors: undefined
  });
  const fetchRuleActionConnectors = (0, _react.useCallback)(async () => {
    try {
      if (!ruleActions || ruleActions.length <= 0) {
        setActionConnector(oldState => ({
          ...oldState,
          isLoadingActionConnectors: false,
          actionConnectors: []
        }));
        return;
      }
      const allActions = await (0, _action_connector_api.loadAllActions)({
        http
      });
      setActionConnector(oldState => ({
        ...oldState,
        isLoadingActionConnectors: false,
        actionConnectors: allActions
      }));
    } catch (error) {
      const errorMsg = ACTIONS_LOAD_ERROR(error instanceof Error ? error.message : typeof error === 'string' ? error : '');
      setActionConnector(oldState => ({
        ...oldState,
        isLoadingActionConnectors: false,
        errorActionConnectors: errorMsg
      }));
      toasts.addDanger({
        title: errorMsg
      });
    }
  }, [http, ruleActions, toasts]);
  (0, _react.useEffect)(() => {
    fetchRuleActionConnectors();
  }, [fetchRuleActionConnectors]);
  return {
    ...actionConnectors,
    reloadRuleActionConnectors: fetchRuleActionConnectors
  };
}