"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkOperationToast = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana = require("../../common/lib/kibana");
var _translations = require("../sections/rules_list/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionToToastMapping = {
  DELETE: {
    getSuccessfulNotificationText: _translations.getSuccessfulDeletionNotificationText,
    getFailedNotificationText: _translations.getFailedDeletionNotificationText,
    getPartialSuccessNotificationText: _translations.getPartialSuccessDeletionNotificationText
  },
  ENABLE: {
    getSuccessfulNotificationText: _translations.getSuccessfulEnablingNotificationText,
    getFailedNotificationText: _translations.getFailedEnablingNotificationText,
    getPartialSuccessNotificationText: _translations.getPartialSuccessEnablingNotificationText
  },
  DISABLE: {
    getSuccessfulNotificationText: _translations.getSuccessfulDisablingNotificationText,
    getFailedNotificationText: _translations.getFailedDisablingNotificationText,
    getPartialSuccessNotificationText: _translations.getPartialSuccessDisablingNotificationText
  }
};
const useBulkOperationToast = ({
  onSearchPopulate
}) => {
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const onSearchPopulateInternal = (0, _react.useCallback)(errors => {
    if (!onSearchPopulate) {
      return;
    }
    const filter = errors.map(error => error.rule.name).join(',');
    onSearchPopulate(filter);
  }, [onSearchPopulate]);
  const renderToastErrorBody = (0, _react.useCallback)((errors, messageType) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "xs"
    }, onSearchPopulate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: messageType,
      size: "s",
      onClick: () => onSearchPopulateInternal(errors),
      "data-test-subj": "bulkDeleteResponseFilterErrors"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleApi.bulkEditResponse.filterByErrors",
      defaultMessage: "Filter by errored rules"
    }))));
  }, [onSearchPopulate, onSearchPopulateInternal]);
  const showToast = (0, _react.useCallback)(({
    action,
    errors,
    total
  }) => {
    const numberOfSuccess = total - errors.length;
    const numberOfErrors = errors.length;

    // All success
    if (!numberOfErrors) {
      toasts.addSuccess(actionToToastMapping[action].getSuccessfulNotificationText(numberOfSuccess, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE));
      return;
    }

    // All failure
    if (numberOfErrors === total) {
      toasts.addDanger({
        title: actionToToastMapping[action].getFailedNotificationText(numberOfErrors, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE),
        text: (0, _public.toMountPoint)(renderToastErrorBody(errors, 'danger'))
      });
      return;
    }

    // Some failure
    toasts.addWarning({
      title: actionToToastMapping[action].getPartialSuccessNotificationText(numberOfSuccess, numberOfErrors, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE),
      text: (0, _public.toMountPoint)(renderToastErrorBody(errors, 'warning'))
    });
  }, [toasts, renderToastErrorBody]);
  return (0, _react.useMemo)(() => {
    return {
      showToast
    };
  }, [showToast]);
};
exports.useBulkOperationToast = useBulkOperationToast;