"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TriggersActionsUIHome = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _get_experimental_features = require("../common/get_experimental_features");
var _constants = require("./constants");
var _breadcrumb = require("./lib/breadcrumb");
var _doc_title = require("./lib/doc_title");
var _health_check = require("./components/health_check");
var _health_context = require("./context/health_context");
var _kibana = require("../common/lib/kibana");
var _suspended_component_with_props = require("./lib/suspended_component_with_props");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const RulesList = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./sections/rules_list/components/rules_list'))));
const LogsList = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./sections/logs_list/components/logs_list'))));
const AlertsPage = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./sections/alerts_table/alerts_page'))));
const TriggersActionsUIHome = ({
  match: {
    params: {
      section
    }
  },
  history
}) => {
  const [headerActions, setHeaderActions] = (0, _react.useState)();
  const {
    chrome,
    setBreadcrumbs
  } = (0, _kibana.useKibana)().services;
  const isInternalAlertsTableEnabled = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('internalAlertsTable');
  const tabs = [];
  tabs.push({
    id: 'rules',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.home.rulesTabTitle",
      defaultMessage: "Rules"
    })
  });
  tabs.push({
    id: 'logs',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.home.logsTabTitle",
      defaultMessage: "Logs"
    })
  });
  if (isInternalAlertsTableEnabled) {
    tabs.push({
      id: 'alerts',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.home.TabTitle",
        defaultMessage: "Alerts (Internal use only)"
      })
    });
  }
  const onSectionChange = newSection => {
    history.push(`/${newSection}`);
  };
  const renderRulesList = (0, _react.useCallback)(() => {
    return (0, _suspended_component_with_props.suspendedComponentWithProps)(RulesList, 'xl')({
      showCreateRuleButtonInPrompt: true,
      setHeaderActions
    });
  }, []);
  const renderLogsList = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
      grow: false,
      paddingSize: "none"
    }, (0, _suspended_component_with_props.suspendedComponentWithProps)(LogsList, 'xl')({
      setHeaderActions
    }));
  }, []);

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)(section || 'home')]);
    chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)(section || 'home'));
  }, [section, chrome, setBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    paddingSize: "none",
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.home.appTitle",
      defaultMessage: "Rules"
    })),
    rightSideItems: headerActions,
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.home.sectionDescription",
      defaultMessage: "Detect conditions using rules."
    }),
    tabs: tabs.map(tab => ({
      label: tab.name,
      onClick: () => onSectionChange(tab.id),
      isSelected: tab.id === section,
      key: tab.id,
      'data-test-subj': `${tab.id}Tab`
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_health_context.HealthContextProvider, null, /*#__PURE__*/_react.default.createElement(_health_check.HealthCheck, {
    waitForCheck: true
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.routeToLogs,
    component: renderLogsList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.routeToRules,
    component: renderRulesList
  }), isInternalAlertsTableEnabled ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.routeToInternalAlerts,
    component: () => /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
      grow: false,
      paddingSize: "none"
    }, (0, _suspended_component_with_props.suspendedComponentWithProps)(AlertsPage, 'xl')({}))
  }) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _constants.routeToRules
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.TriggersActionsUIHome = TriggersActionsUIHome;