"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleConnectorForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _i18n = require("@kbn/i18n");
var _password_field = require("./password_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UseField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const getFieldConfig = ({
  label,
  isUrlField = false,
  defaultValue
}) => ({
  label,
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorForm.error.requireFieldText', {
      values: {
        label
      },
      defaultMessage: `{label} is required.`
    }))
  }, ...(isUrlField ? [{
    validator: urlField(_i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorForm.error.invalidURL', {
      defaultMessage: 'Invalid URL'
    }))
  }] : [])],
  defaultValue
});
const FormRow = ({
  id,
  label,
  readOnly,
  isPasswordField,
  isUrlField,
  helpText,
  defaultValue
}) => {
  const dataTestSub = `${id}-input`;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !isPasswordField ? /*#__PURE__*/_react.default.createElement(UseField, {
    path: id,
    config: getFieldConfig({
      label,
      isUrlField,
      defaultValue
    }),
    helpText: helpText,
    componentProps: {
      euiFieldProps: {
        readOnly,
        fullWidth: true,
        'data-test-subj': dataTestSub
      }
    }
  }) : /*#__PURE__*/_react.default.createElement(_password_field.PasswordField, {
    path: id,
    label: label,
    readOnly: readOnly,
    "data-test-subj": dataTestSub,
    helpText: helpText
  }))));
};
const SimpleConnectorFormComponent = ({
  isEdit,
  readOnly,
  configFormSchema,
  secretsFormSchema
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, configFormSchema.map(({
    id,
    ...restConfigSchema
  }, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: `config.${id}`
  }, /*#__PURE__*/_react.default.createElement(FormRow, (0, _extends2.default)({
    id: `config.${id}`
  }, restConfigSchema, {
    readOnly: readOnly
  })), index !== configFormSchema.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.triggersActionsUI.components.simpleConnectorForm.secrets.authenticationLabel', {
    defaultMessage: 'Authentication'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), secretsFormSchema.map(({
    id,
    ...restSecretsSchema
  }, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: `secrets.${id}`
  }, /*#__PURE__*/_react.default.createElement(FormRow, (0, _extends2.default)({
    id: `secrets.${id}`,
    key: `secrets.${id}`
  }, restSecretsSchema, {
    readOnly: readOnly
  })), index !== secretsFormSchema.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }) : null)));
};
const SimpleConnectorForm = /*#__PURE__*/(0, _react.memo)(SimpleConnectorFormComponent);
exports.SimpleConnectorForm = SimpleConnectorForm;