"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPrompt = ({
  onCreateRulesClick,
  showCreateRule = true
}) => {
  const renderActions = () => {
    if (showCreateRule) {
      return [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "plusInCircle",
        "data-test-subj": "createFirstRuleButton",
        key: "create-action",
        fill: true,
        onClick: onCreateRulesClick
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.components.emptyPrompt.emptyButton",
        defaultMessage: "Create rule"
      }))];
    }
    return null;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    iconType: "watchesApp",
    "data-test-subj": "createFirstRuleEmptyPrompt",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.components.emptyPrompt.emptyTitle",
      defaultMessage: "Create your first rule"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.components.emptyPrompt.emptyDesc",
      defaultMessage: "Receive an alert through email, Slack, or another connector when a condition is met."
    })),
    actions: renderActions()
  });
};
exports.EmptyPrompt = EmptyPrompt;