"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonFieldWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _react = _interopRequireWildcard(require("react"));
var _json_field_wrapper = require("./json_field_wrapper.styles");
var _json_editor_with_message_variables = require("./json_editor_with_message_variables");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JsonFieldWrapper = ({
  field,
  ...rest
}) => {
  const {
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const {
    label,
    helpText,
    value,
    setValue
  } = field;
  const onJsonUpdate = (0, _react.useCallback)(updatedJson => {
    setValue(updatedJson);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement("span", {
    css: _json_field_wrapper.styles.editor
  }, /*#__PURE__*/_react.default.createElement(_json_editor_with_message_variables.JsonEditorWithMessageVariables, (0, _extends2.default)({
    errors: errorMessage ? [errorMessage] : [],
    helpText: /*#__PURE__*/_react.default.createElement("p", null, helpText),
    inputTargetValue: value,
    label: label !== null && label !== void 0 ? label : _i18n.i18n.translate('xpack.triggersActionsUI.jsonFieldWrapper.defaultLabel', {
      defaultMessage: 'JSON Editor'
    }),
    onDocumentsChange: onJsonUpdate
  }, rest)));
};
exports.JsonFieldWrapper = JsonFieldWrapper;