"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ButtonGroupField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const getFieldConfig = ({
  label,
  defaultValue
}) => ({
  label,
  defaultValue,
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.triggersActionsUI.components.buttonGroupField.error.requiredField', {
      values: {
        label
      },
      defaultMessage: '{label} is required.'
    }))
  }]
});
const ButtonGroupFieldComponent = ({
  path,
  label,
  helpText,
  defaultValue,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    config: getFieldConfig({
      label,
      defaultValue
    })
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: field.label,
      labelAppend: field.labelAppend,
      helpText: helpText,
      error: errorMessage,
      isInvalid: isInvalid,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, (0, _extends2.default)({
      isFullWidth: true,
      buttonSize: "m",
      legend: "Select",
      color: "primary",
      options: [],
      idSelected: field.value,
      onChange: field.setValue
    }, rest)));
  });
};
const ButtonGroupField = /*#__PURE__*/(0, _react.memo)(ButtonGroupFieldComponent);
exports.ButtonGroupField = ButtonGroupField;