"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMessageVariables = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
require("./add_message_variables.scss");
var _truncated_text = require("../../common/truncated_text");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddMessageVariables = ({
  buttonTitle,
  messageVariables,
  paramsProperty,
  onSelectEventHandler,
  showButtonTitle = false
}) => {
  var _messageVariables$len;
  const [isShowAllPressed, setIsShowAllPressed] = (0, _react.useState)(false);
  const [isVariablesPopoverOpen, setIsVariablesPopoverOpen] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const messageVariablesObject = (0, _react.useMemo)(() => messageVariables === null || messageVariables === void 0 ? void 0 : messageVariables.reduce((acc, variable) => {
    return {
      ...acc,
      [variable.name]: variable
    };
  }, {}), [messageVariables]);
  const messageVariablesToShow = (0, _react.useMemo)(() => isShowAllPressed ? messageVariables : messageVariables === null || messageVariables === void 0 ? void 0 : messageVariables.filter(variable => !variable.deprecated), [messageVariables, isShowAllPressed]);
  const optionsToShow = (0, _react.useMemo)(() => {
    return messageVariablesToShow === null || messageVariablesToShow === void 0 ? void 0 : messageVariablesToShow.map(variable => ({
      label: variable.name,
      ...(variable.deprecated ? {
        disabled: true
      } : {}),
      data: {
        description: variable.description
      },
      'data-test-subj': `${variable.name}-selectableOption`
    }));
  }, [messageVariablesToShow]);
  const addVariableButtonTitle = buttonTitle ? buttonTitle : i18n.ADD_VARIABLE_TITLE;
  const Button = (0, _react.useMemo)(() => showButtonTitle ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    id: `${paramsProperty}AddVariableButton`,
    "data-test-subj": `${paramsProperty}AddVariableButton-Title`,
    size: "xs",
    onClick: () => setIsVariablesPopoverOpen(true),
    "aria-label": i18n.ADD_VARIABLE_POPOVER_BUTTON
  }, addVariableButtonTitle) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    id: `${paramsProperty}AddVariableButton`,
    "data-test-subj": `${paramsProperty}AddVariableButton`,
    title: addVariableButtonTitle,
    onClick: () => setIsVariablesPopoverOpen(true),
    iconType: "indexOpen",
    "aria-label": i18n.ADD_VARIABLE_POPOVER_BUTTON
  }), [addVariableButtonTitle, paramsProperty, showButtonTitle]);
  if (((_messageVariables$len = messageVariables === null || messageVariables === void 0 ? void 0 : messageVariables.length) !== null && _messageVariables$len !== void 0 ? _messageVariables$len : 0) === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const ToolTipContent = ({
    description,
    label
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      style: {
        fontWeight: euiTheme.font.weight.bold
      }
    }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("hr", null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, description));
  };
  const renderOption = (option, searchValue) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": `variableMenuButton-${option.label}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      style: {
        fontWeight: euiTheme.font.weight.bold
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue
    }, option.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), option.description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "block",
      position: "top",
      content: /*#__PURE__*/_react.default.createElement(ToolTipContent, {
        description: option.description,
        label: option.label
      }),
      "data-test-subj": `${option.label}-tooltip`
    }, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
      text: option.description || ''
    })))));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: Button,
    isOpen: isVariablesPopoverOpen,
    closePopover: () => setIsVariablesPopoverOpen(false),
    panelPaddingSize: "s",
    anchorPosition: "upRight",
    panelStyle: {
      minWidth: 350
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    height: 300,
    "data-test-subj": 'messageVariablesSelectableList',
    isLoading: false,
    options: optionsToShow,
    listProps: {
      rowHeight: 70,
      showIcons: false,
      paddingSize: 'none',
      textWrap: 'wrap'
    },
    loadingMessage: i18n.LOADING_VARIABLES,
    noMatchesMessage: i18n.NO_VARIABLES_FOUND,
    emptyMessage: i18n.NO_VARIABLES_AVAILABLE,
    renderOption: renderOption,
    onChange: variables => {
      variables.map(variable => {
        if (variable.checked === 'on' && messageVariablesObject) {
          onSelectEventHandler(messageVariablesObject[variable.label]);
        }
      });
      setIsVariablesPopoverOpen(false);
    },
    singleSelection: true,
    searchProps: {
      'data-test-subj': 'messageVariablesSelectableSearch'
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), list, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    style: {
      paddingTop: 0,
      paddingBottom: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceBetween",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "grey",
    size: "xs"
  }, isShowAllPressed ? i18n.DEPRECATED_VARIABLES_ARE_SHOWN : i18n.DEPRECATED_VARIABLES_ARE_HIDDEN)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": 'showDeprecatedVariablesButton',
    size: "xs",
    onClick: () => isShowAllPressed ? setIsShowAllPressed(false) : setIsShowAllPressed(true)
  }, isShowAllPressed ? i18n.HIDE : i18n.SHOW_ALL)))))));
};
exports.AddMessageVariables = AddMessageVariables;