"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAggregationResults = exports.UngroupedGroupId = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UngroupedGroupId = 'all documents';
exports.UngroupedGroupId = UngroupedGroupId;
const parseAggregationResults = ({
  isCountAgg,
  isGroupAgg,
  esResult,
  resultLimit
}) => {
  var _aggregations$groupAg, _aggregations$groupAg2, _aggregations$groupAg3;
  const aggregations = (esResult === null || esResult === void 0 ? void 0 : esResult.aggregations) || {};

  // add a fake 'all documents' group aggregation, if a group aggregation wasn't used
  if (!isGroupAgg) {
    var _esResult$hits$hits, _value, _aggregations$metricA;
    aggregations.groupAgg = {
      buckets: [{
        key: UngroupedGroupId,
        doc_count: totalHitsToNumber(esResult.hits.total),
        topHitsAgg: {
          hits: {
            hits: (_esResult$hits$hits = esResult.hits.hits) !== null && _esResult$hits$hits !== void 0 ? _esResult$hits$hits : []
          }
        },
        ...(!isCountAgg ? {
          metricAgg: {
            value: (_value = (_aggregations$metricA = aggregations.metricAgg) === null || _aggregations$metricA === void 0 ? void 0 : _aggregations$metricA.value) !== null && _value !== void 0 ? _value : 0
          }
        } : {})
      }]
    };
  }

  // @ts-expect-error specify aggregations type explicitly
  const groupBuckets = ((_aggregations$groupAg = aggregations.groupAgg) === null || _aggregations$groupAg === void 0 ? void 0 : _aggregations$groupAg.buckets) || [];
  // @ts-expect-error specify aggregations type explicitly
  const numGroupsTotal = (_aggregations$groupAg2 = (_aggregations$groupAg3 = aggregations.groupAggCount) === null || _aggregations$groupAg3 === void 0 ? void 0 : _aggregations$groupAg3.count) !== null && _aggregations$groupAg2 !== void 0 ? _aggregations$groupAg2 : 0;
  const results = {
    results: [],
    truncated: resultLimit ? numGroupsTotal > resultLimit : false
  };
  for (const groupBucket of groupBuckets) {
    var _groupBucket$topHitsA, _groupBucket$topHitsA2, _groupBucket$topHitsA3, _groupBucket$metricAg;
    if (resultLimit && results.results.length === resultLimit) break;
    const groupName = `${groupBucket === null || groupBucket === void 0 ? void 0 : groupBucket.key}`;
    const groupResult = {
      group: groupName,
      count: groupBucket === null || groupBucket === void 0 ? void 0 : groupBucket.doc_count,
      hits: (_groupBucket$topHitsA = groupBucket === null || groupBucket === void 0 ? void 0 : (_groupBucket$topHitsA2 = groupBucket.topHitsAgg) === null || _groupBucket$topHitsA2 === void 0 ? void 0 : (_groupBucket$topHitsA3 = _groupBucket$topHitsA2.hits) === null || _groupBucket$topHitsA3 === void 0 ? void 0 : _groupBucket$topHitsA3.hits) !== null && _groupBucket$topHitsA !== void 0 ? _groupBucket$topHitsA : [],
      ...(!isCountAgg ? {
        value: groupBucket === null || groupBucket === void 0 ? void 0 : (_groupBucket$metricAg = groupBucket.metricAgg) === null || _groupBucket$metricAg === void 0 ? void 0 : _groupBucket$metricAg.value
      } : {})
    };
    results.results.push(groupResult);
  }
  return results;
};
exports.parseAggregationResults = parseAggregationResults;
function totalHitsToNumber(total) {
  var _total$value;
  return typeof total === 'number' ? total : (_total$value = total === null || total === void 0 ? void 0 : total.value) !== null && _total$value !== void 0 ? _total$value : 0;
}