"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupCapabilities = exports.TRANSFORM_PLUGIN_ID = void 0;
var _has_privilege_factory = require("../common/privilege/has_privilege_factory");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRANSFORM_PLUGIN_ID = 'transform';
exports.TRANSFORM_PLUGIN_ID = TRANSFORM_PLUGIN_ID;
const setupCapabilities = (core, securitySetup) => {
  core.capabilities.registerProvider(() => {
    return {
      transform: _has_privilege_factory.INITIAL_CAPABILITIES
    };
  });
  core.capabilities.registerSwitcher(async (request, capabilities, useDefaultCapabilities) => {
    var _securitySetup$licens, _privileges$elasticse;
    if (useDefaultCapabilities) {
      return {};
    }
    const isSecurityPluginEnabled = (_securitySetup$licens = securitySetup === null || securitySetup === void 0 ? void 0 : securitySetup.license.isEnabled()) !== null && _securitySetup$licens !== void 0 ? _securitySetup$licens : false;
    const startServices = await core.getStartServices();
    const [, {
      security: securityStart
    }] = startServices;

    // If security is not enabled or not available, transform should have full permission
    if (!isSecurityPluginEnabled || !securityStart) {
      return {
        transform: Object.keys(_has_privilege_factory.INITIAL_CAPABILITIES).reduce((acc, p) => {
          acc[p] = true;
          return acc;
        }, {})
      };
    }
    const checkPrivileges = securityStart.authz.checkPrivilegesDynamicallyWithRequest(request);
    const {
      hasAllRequested,
      privileges
    } = await checkPrivileges({
      elasticsearch: {
        cluster: _constants.APP_CLUSTER_PRIVILEGES,
        index: {}
      }
    });
    const clusterPrivileges = Array.isArray(privileges === null || privileges === void 0 ? void 0 : (_privileges$elasticse = privileges.elasticsearch) === null || _privileges$elasticse === void 0 ? void 0 : _privileges$elasticse.cluster) ? privileges.elasticsearch.cluster.reduce((acc, p) => {
      acc[p.privilege] = p.authorized;
      return acc;
    }, {}) : {};
    const hasOneIndexWithAllPrivileges = false;
    const transformCapabilities = (0, _has_privilege_factory.getPrivilegesAndCapabilities)(clusterPrivileges, hasOneIndexWithAllPrivileges, hasAllRequested).capabilities;
    return {
      transform: transformCapabilities
    };
  });
};
exports.setupCapabilities = setupCapabilities;