"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformUiPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _register_feature = require("./register_feature");
var _alerting = require("./alerting");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class TransformUiPlugin {
  setup(coreSetup, pluginsSetup) {
    const {
      management,
      home,
      triggersActionsUi
    } = pluginsSetup;

    // Register management section
    const esSection = management.sections.section.data;
    esSection.registerApp({
      id: 'transform',
      title: _i18n.i18n.translate('xpack.transform.appTitle', {
        defaultMessage: 'Transforms'
      }),
      order: 5,
      mount: async params => {
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app/mount_management_section')));
        return mountManagementSection(coreSetup, params);
      }
    });
    (0, _register_feature.registerFeature)(home);
    if (triggersActionsUi) {
      triggersActionsUi.ruleTypeRegistry.register((0, _alerting.getTransformHealthRuleType)());
    }
  }
  start() {}
  stop() {}
}
exports.TransformUiPlugin = TransformUiPlugin;