"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.textService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TextService {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbs", {});
  }
  init() {
    this.breadcrumbs = {
      home: _i18n.i18n.translate('xpack.transform.home.breadcrumbTitle', {
        defaultMessage: 'Transforms'
      }),
      cloneTransform: _i18n.i18n.translate('xpack.transform.cloneTransform.breadcrumbTitle', {
        defaultMessage: 'Clone transform'
      }),
      createTransform: _i18n.i18n.translate('xpack.transform.createTransform.breadcrumbTitle', {
        defaultMessage: 'Create transform'
      })
    };
  }
  getSizeNotationHelpText() {
    return _i18n.i18n.translate('xpack.transform.transformForm.sizeNotationPlaceholder', {
      defaultMessage: 'Examples: {example1}, {example2}, {example3}, {example4}',
      values: {
        example1: '1g',
        example2: '10mb',
        example3: '5k',
        example4: '1024B'
      }
    });
  }
}
const textService = new TextService();
exports.textService = textService;