"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexService = exports.IndexService = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndexService {
  async canDeleteIndex(http) {
    const privilege = await http.get(`${_constants.API_BASE_PATH}privileges`);
    if (!privilege) {
      return false;
    }
    return privilege.hasAllPrivileges;
  }
  async dataViewExists(dataViewsContract, indexName) {
    return (await dataViewsContract.find(indexName)).some(({
      title
    }) => title === indexName);
  }
}
exports.IndexService = IndexService;
const indexService = new IndexService();
exports.indexService = indexService;